package org.modellwerkstatt.h2forms.pebble;

/*Generated by MPS */

import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import org.modellwerkstatt.dataux.runtime.core.FocusController;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_Form;
import org.modellwerkstatt.objectflow.runtime.IOFXSelection;
import java.io.Writer;
import org.modellwerkstatt.h2forms.core.ContextStatics;
import org.modellwerkstatt.h2forms.core.ContextClient;
import org.modellwerkstatt.h2forms.core.ContextPage;
import javax.servlet.http.HttpServletRequest;

public abstract class HasChildForms<T> extends AbstractForm {
  protected List<AbstractForm> children = ListSequence.fromList(new ArrayList<AbstractForm>());
  protected FocusController focusController;

  public HasChildForms(PebbleTemplate template) {
    super(template);
    focusController = new FocusController();
  }

  public void addChildren(IToolkit_Form child) {
    focusController.addChild(child);
    ListSequence.fromList(children).addElement(((AbstractForm) child));
  }

  public boolean selectionChanged(IOFXSelection<T> selection) {
    return false;
  }
  public void loadList(List<T> objects, IOFXSelection<T> selection) {
  }

  @Override
  public void afterFullUiInitialized() {
    super.afterFullUiInitialized();
    focusController.afterFullUiInitialized();
  }
  public Object myRequestFocus() {
    return focusController.myRequestFocus();
  }

  @Override
  public void initBeforeRender(int id, Writer writer, ContextStatics stat, ContextClient clnt, ContextPage pg) {
    super.initBeforeRender(id, writer, stat, clnt, pg);
    for (AbstractForm form : children) {
      id++;
      form.initBeforeRender(id, writer, stat, clnt, pg);
    }

  }

  public boolean actionInForm(int formId, int selectionNum, int actionId) {
    boolean consumed = false;

    for (AbstractForm form : children) {
      consumed = form.actionInForm(formId, selectionNum, actionId);
      if (consumed) {
        break;
      }
    }

    return consumed;
  }

  public void delegateDataInForm(HttpServletRequest request) {
    for (AbstractForm form : children) {
      form.delegateDataInForm(request);
    }
  }
  @Override
  public AbstractEditor firstEditorFocused() {

    for (AbstractForm form : children) {
      AbstractEditor edtr = form.firstEditorFocused();
      if (edtr != null) {
        return edtr;
      }
    }

    return null;
  }

  public boolean delegatesNeedKeyboard() {
    for (AbstractForm form : children) {
      if (form.delegatesNeedKeyboard()) {
        return true;
      }
    }
    return false;
  }

  public String debugInfo() {
    String s = "";
    for (AbstractForm form : children) {
      s += form.debugInfo();
    }
    return s;
  }

  public void gcClear() {
    focusController.gcClear();
    ListSequence.fromList(children).clear();
  }
}
