package org.modellwerkstatt.h2forms.pebble;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_ImageEditor;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import java.io.IOException;
import java.util.Map;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import org.modellwerkstatt.dataux.runtime.delegates.ImageDelegate;
import javax.servlet.http.HttpServletRequest;

public class ImageEditor extends AbstractEditor implements IToolkit_ImageEditor {
  protected String imageName;

  protected String uploadLocationStore;
  protected String uploadLocationRetrieve;
  protected String maxHeight;
  protected String maxWidth;

  public ImageEditor(PebbleTemplate template, String aUploadLocationStore, String aUploadLocationRetrieve) {
    super("imgEditor", template);

    uploadLocationRetrieve = aUploadLocationRetrieve;
    uploadLocationStore = aUploadLocationStore;
    maxHeight = null;
    maxWidth = null;
  }

  @Override
  public void setDelegate(IDataUxDelegate dlgt) {
  }
  @Override
  public void setText(String text) {
    imageName = text;
  }
  @Override
  public String getText() {
    return imageName;
  }
  @Override
  public void setEditorPrompt(String promptText) {

    String[] xySplit = promptText.split(",");
    String xVal = xySplit[0].trim();
    String yVal = xySplit[1].trim();

    if (!("0".equals(xVal))) {
      maxWidth = xVal + "px";
    }
    if (!("0".equals(yVal))) {
      maxHeight = yVal + "px";
    }
  }

  @Override
  public void toHtml() throws IOException {
    Map<String, Object> renderMap = initAndGetRenderMap();

    MapSequence.fromMap(renderMap).put(VALUE, ImageDelegate.adjustPath(uploadLocationRetrieve, imageName));
    MapSequence.fromMap(renderMap).put(UPLOADLOCATIONSTORE, uploadLocationStore);
    MapSequence.fromMap(renderMap).put(UPLOADLOCATIONRETRIEVE, uploadLocationRetrieve);
    MapSequence.fromMap(renderMap).put(MAX_WIDTH, maxWidth);
    MapSequence.fromMap(renderMap).put(MAX_HEIGHT, maxHeight);

    compiledTextEditorTemplate.evaluate(writerToUse, renderMap);
  }

  @Override
  public void handleRequest(HttpServletRequest req) {
  }


}
