package org.modellwerkstatt.h2forms.pebble;

/*Generated by MPS */

import org.modellwerkstatt.dataux.runtime.core.BaseUiFactory;
import org.modellwerkstatt.h2forms.core.IH2UiFactory;
import org.modellwerkstatt.h2forms.core.ContextStatics;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import org.modellwerkstatt.dataux.runtime.utils.MoWareTranslations;
import javax.servlet.ServletContext;
import org.modellwerkstatt.h2forms.core.H2Licenses;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.modellwerkstatt.h2forms.core.IH2FormsTemplateRenderer;
import org.modellwerkstatt.h2forms.core.IH2Controller;
import org.modellwerkstatt.dataux.runtime.genspecifications.IGenAppUiModule;
import org.modellwerkstatt.dataux.runtime.telemetrics.AppJmxRegistration;
import org.modellwerkstatt.h2forms.core.ContextClient;
import org.modellwerkstatt.h2forms.mdeauth.H2MpreisNoLoginAuth;
import org.modellwerkstatt.h2forms.mdeauth.H2MpreisTrialFirstAuth;
import org.modellwerkstatt.h2forms.mdeauth.H2MpreisLoginOAuth;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_CommandContainerUi;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_MainWindow;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_FormContainer;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TabForm;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TableForm;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_DelegateForm;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_DateOrTimeEditor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_TextEditor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_ReferenceEditor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_StatusEditor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_ImageEditor;
import org.modellwerkstatt.dataux.runtime.toolkit.IToolkit_UploadEditor;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.modellwerkstatt.dataux.runtime.telemetrics.Dux;

public class PAppFactory extends BaseUiFactory implements IH2UiFactory {
  public static final String SUIVANT_TEMPLATE = "template_suivant";
  public static final String SUIVANT_MPREIS_RESSOURCES = "mpreis";
  private String[] specialJsDebugUsers = new String[]{};


  private PebbleTemplateRenderer preconfiguretdRenderer;
  private ContextStatics ctxStatics;
  private String authentiactorName;
  private String dividerNamer;


  private PebbleTemplate commandUiTemplate;
  private PebbleTemplate formTemplate;
  private PebbleTemplate tableTemplate;
  private PebbleTemplate delegateTemplate;
  private PebbleTemplate tabTemplate;

  private PebbleTemplate textEditor;
  private PebbleTemplate dateTimeEditor;
  private PebbleTemplate referenceEditor;
  private PebbleTemplate statusEditor;

  private PebbleTemplate uploadEditor;
  private PebbleTemplate imageEditor;


  public PAppFactory() {
    super(MoWareTranslations.TranslationSelection.H1_TRANSLATIONS);
    ctxStatics = new ContextStatics();
    ctxStatics.setTemplateName(SUIVANT_TEMPLATE);
    ctxStatics.setStaticRessources(SUIVANT_MPREIS_RESSOURCES);
    ctxStatics.setStrichLicenseKey("-");
    ctxStatics.setScroll(this.scrollAdjustEnabled);
    ctxStatics.setUploadLocationRetrieve("-");
    ctxStatics.setUploadLocationStore("-");
    ctxStatics.setCamDesiredHeight(1920);
    ctxStatics.setCamDesiredWidth(1080);
    ctxStatics.setCamUseSystemViewfinder(true);

    authentiactorName = "org.modellwerkstatt.h2forms.mdeauth.H2MpreisNoLoginAuth";
    dividerNamer = "org.modellwerkstatt.h2forms.pebble.TwelveWeightDivider";
  }
  public int getCamDesiredHeight() {
    return ctxStatics.getCamDesiredHeight();
  }
  public void setCamDesiredHeight(int val) {
    ctxStatics.setCamDesiredHeight(val);
  }

  public int getCamDesiredWidth() {
    return ctxStatics.getCamDesiredWidth();
  }
  public void setCamDesiredWidth(int val) {
    ctxStatics.setCamDesiredWidth(val);
  }
  public boolean getCamUseSystemViewfinder() {
    return ctxStatics.isCamUseSystemViewfinder();
  }
  public void setCamUseSystemViewfinder(boolean val) {
    ctxStatics.setCamUseSystemViewfinder(val);
  }
  @Override
  public void setScrollAdjust(boolean val) {
    super.setScrollAdjust(val);
    ctxStatics.setScroll(this.scrollAdjustEnabled);
  }
  public ContextStatics getContextStatics() {
    return ctxStatics;
  }
  public void setTemplateName(String name) {
    ctxStatics.setTemplateName(name);
  }
  public void setAuthenticatorName(String name) {
    authentiactorName = name;
  }
  public void setTableColDivider(String name) {
    dividerNamer = name;
  }

  @Override
  public void setUploadLocationRetrieve(String name) {
    super.setUploadLocationRetrieve(name);
    ctxStatics.setUploadLocationRetrieve(uploadLocationRetrieve);
  }
  @Override
  public void setUploadLocationStore(String name) {
    super.setUploadLocationStore(name);
    ctxStatics.setUploadLocationStore(uploadLocationStore);
  }


  public void initRenderer(ServletContext servletContext) {

    try {
      H2Licenses lic = ((H2Licenses) context.getBean(H2Licenses.class));
      ctxStatics.setStrichLicenseKey(lic.getStrichLicenseKey());

    } catch (NoSuchBeanDefinitionException ex) {
      // ok, no licenses found
    }

    preconfiguretdRenderer = new PebbleTemplateRenderer();

    if (ctxStatics.getTemplateName() == null || "".equals(ctxStatics.getTemplateName())) {
      throw new IllegalStateException("No 'templateName' configured for this ui-factory.");
    }

    preconfiguretdRenderer.initTemplates(servletContext, ctxStatics.getTemplateName(), "ui_landing", "ui_login");

    commandUiTemplate = preconfiguretdRenderer.compileTemplateFor(ctxStatics.getTemplateName(), "ui_command");
    formTemplate = preconfiguretdRenderer.compileTemplateFor(ctxStatics.getTemplateName(), "form_layout");
    tableTemplate = preconfiguretdRenderer.compileTemplateFor(ctxStatics.getTemplateName(), "form_table");
    delegateTemplate = preconfiguretdRenderer.compileTemplateFor(ctxStatics.getTemplateName(), "form_delegate");
    tabTemplate = preconfiguretdRenderer.compileTemplateFor(ctxStatics.getTemplateName(), "form_tab");

    textEditor = preconfiguretdRenderer.compileTemplateFor(ctxStatics.getTemplateName(), "editor_text");
    dateTimeEditor = preconfiguretdRenderer.compileTemplateFor(ctxStatics.getTemplateName(), "editor_text");
    referenceEditor = preconfiguretdRenderer.compileTemplateFor(ctxStatics.getTemplateName(), "editor_reference");
    statusEditor = preconfiguretdRenderer.compileTemplateFor(ctxStatics.getTemplateName(), "editor_status");
    uploadEditor = preconfiguretdRenderer.compileTemplateFor(ctxStatics.getTemplateName(), "editor_upload");
    imageEditor = preconfiguretdRenderer.compileTemplateFor(ctxStatics.getTemplateName(), "editor_image");

  }

  public IH2FormsTemplateRenderer getRenderer() {
    return preconfiguretdRenderer;
  }

  public void setDebugUsers(String st) {
    specialJsDebugUsers = st.split(",");
    for (int i = 0; i < specialJsDebugUsers.length; i++) {
      specialJsDebugUsers[i] = specialJsDebugUsers[i].trim().toLowerCase();
    }
  }
  public boolean isDebugUsers(String user) {
    for (int i = 0; i < specialJsDebugUsers.length; i++) {
      if (user.toLowerCase().equals(specialJsDebugUsers[i])) {
        return true;
      }
    }
    return false;
  }

  @Override
  public String getSettingsDescription() {
    return super.getSettingsDescription() + " " + ctxStatics.toString();
  }
  @Override
  public boolean useBackgroundThread() {
    return false;
  }
  @Override
  public boolean flagValidationAdditionally() {
    return false;
  }
  public IH2Controller createLoginController(IGenAppUiModule genApp, AppJmxRegistration regHelper, ContextClient ctxClient) {
    if (authentiactorName.equals(H2MpreisNoLoginAuth.class.getName())) {
      return new H2MpreisNoLoginAuth(this, genApp, regHelper, ctxClient);

    } else if (authentiactorName.equals(H2MpreisTrialFirstAuth.class.getName())) {
      return new H2MpreisTrialFirstAuth(this, genApp, regHelper, ctxClient);

    } else if (authentiactorName.equals(H2MpreisLoginOAuth.class.getName())) {
      return new H2MpreisLoginOAuth(this, genApp, regHelper, ctxClient);

    } else {
      throw new IllegalStateException("Authenticator '" + authentiactorName + "' is not known to this app. factory.");
    }
  }
  public IToolkit_CommandContainerUi createTabContainerUi(IToolkit_MainWindow app, boolean modal) {
    return new CommandContainerUi(commandUiTemplate, scrollAdjustEnabled, optimKeyboard);
  }
  public IToolkit_CommandContainerUi createPromptContainerUi(IToolkit_MainWindow app, boolean fullSize) {
    return new CommandContainerUi(commandUiTemplate, scrollAdjustEnabled, optimKeyboard);
  }
  public IToolkit_FormContainer createToolkitFormContainer(boolean flex) {
    return new FormContainer(formTemplate);
  }
  public IToolkit_TabForm createToolkitTabForm() {
    return new TabForm(tabTemplate);
  }
  public IToolkit_TableForm createToolkitTableForm() {
    if ("org.modellwerkstatt.h2forms.pebble.TwoTop12Divider".equals(this.dividerNamer)) {
      return new TableForm(tableTemplate, new TwoTop12Divider());

    } else {
      return new TableForm(tableTemplate, new TwelveWeightDivider());
    }
  }
  public IToolkit_DelegateForm createToolkitDelegateForm() {
    return new DelegateForm(delegateTemplate);
  }
  public IToolkit_DateOrTimeEditor createDateAndTimeEditor(boolean withPicker, boolean timeOnly) {
    return new DateOrTimeEditor(this, dateTimeEditor, false);
  }
  public IToolkit_TextEditor createTextEditor() {
    return new TextEditor(textEditor, 1);
  }
  public IToolkit_ReferenceEditor createReferenceEditor(boolean alter) {
    return new ReferenceEditor(referenceEditor, alter);
  }
  public IToolkit_StatusEditor createStatusEditor(boolean alter) {
    return new StatusEditor(statusEditor, alter);
  }
  public IToolkit_DateOrTimeEditor createDateEditor(boolean withPicker) {
    return new DateOrTimeEditor(this, dateTimeEditor, withPicker);
  }
  public IToolkit_ImageEditor createImageEditor() {
    return new ImageEditor(imageEditor, ctxStatics.getUploadLocationStore(), ctxStatics.getUploadLocationRetrieve());
  }
  public IToolkit_TextEditor createTextAreaEditor(int numOfLines) {
    return new TextEditor(textEditor, numOfLines);
  }
  @Override
  public IToolkit_TextEditor createDummyEditor() {
    TextEditor txt = new TextEditor(textEditor, 1);
    txt.setEnabled(false);
    return txt;
  }

  @Override
  public IToolkit_UploadEditor createUploadEditor() {
    return new UploadEditor(uploadEditor, ctxStatics.getUploadLocationStore(), ctxStatics.getUploadLocationRetrieve());
  }

  public void execLocationRedirect(HttpServletResponse response, String url) throws IOException {
    Dux.hl(" factory redirecting to " + url);
    response.sendRedirect(response.encodeRedirectURL(url));
  }
}
