package org.modellwerkstatt.h2forms.pebble;

/*Generated by MPS */

import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;

public class TwelveWeightDivider extends AbstractColumnDivider {
  private List<Integer> singleLineWeights;
  private List<Boolean> closingRow;


  public TwelveWeightDivider() {
    super();
  }

  @Override
  public void init(List<TableForm.Column> cols) {
    super.init(cols);

    if (ListSequence.fromList(cols).count() > 12) {
      throw new RuntimeException("This table column-divider only supports only up to 12 cols. You are using " + ListSequence.fromList(cols).count() + " cols.");
    }

    singleLineWeights = ListSequence.fromList(new ArrayList<Integer>());
    closingRow = ListSequence.fromList(new ArrayList<Boolean>());

    ListSequence.fromList(cols).visitAll((it) -> {
      ListSequence.fromList(singleLineWeights).addElement(((int) Math.round(((float) it.width) / 8.33)));
      ListSequence.fromList(closingRow).addElement(false);
    });

    // check if we have 12 total
    int total = IntListHelper.sum(singleLineWeights);

    if (total == 12) {
      // nice
    } else if (total > 12) {
      int indexOfMax = IntListHelper.maxAsIndex(singleLineWeights);
      ListSequence.fromList(singleLineWeights).setElement(indexOfMax, ListSequence.fromList(singleLineWeights).getElement(indexOfMax) - (total - 12));

    } else if (total < 12) {
      int indexOfMin = IntListHelper.minAsIndex(singleLineWeights);
      ListSequence.fromList(singleLineWeights).setElement(indexOfMin, ListSequence.fromList(singleLineWeights).getElement(indexOfMin) + (12 - total));

    }



    // final check ..
    if (ListSequence.fromList(singleLineWeights).any((it) -> it <= 0)) {
      throw new RuntimeException("After calculating weights for columns, we ended up with 0 weights for some cols. This should not happen (cols weights " + singleLineWeights + ")!");
    }

    // where do we divide cols?
    int sum = 0;
    for (int i = 0; i < ListSequence.fromList(singleLineWeights).count(); i++) {
      sum += ListSequence.fromList(singleLineWeights).getElement(i);
      if (sum % 6 == 0) {
        ListSequence.fromList(closingRow).setElement(i, true);
      } else if ((sum > 6 && ListSequence.fromList(closingRow).all((it) -> it == false)) && i > 0) {
        ListSequence.fromList(closingRow).setElement(i - 1, true);
      }
    }
  }

  public boolean needsCloseRow(int colIndex) {
    return ListSequence.fromList(closingRow).getElement(colIndex);
  }

  public boolean needsOpenRow(int colIndex) {
    return false;
  }

  public int getSizeS(int colIndex) {
    return getSizeM(colIndex) * 2;
  }
  public int getSizeM(int colIndex) {
    return ListSequence.fromList(singleLineWeights).getElement(colIndex);
  }

  public int numOfEmptyCellToAdd() {
    return 0;
  }


  public static void main(String[] args) {
    TableForm.Column single8 = new TableForm.Column("prop", "lab", null, 8, false);
    TwelveWeightDivider d1 = new TwelveWeightDivider();
    d1.init(ListSequence.fromListAndArray(new ArrayList<TableForm.Column>(), single8, single8, single8, single8, single8, single8, single8, single8, single8, single8, single8, single8));

    TwelveWeightDivider d2 = new TwelveWeightDivider();
    d2.init(ListSequence.fromListAndArray(new ArrayList<TableForm.Column>(), single8, single8));

    TwelveWeightDivider d3 = new TwelveWeightDivider();
    d3.init(ListSequence.fromListAndArray(new ArrayList<TableForm.Column>(), single8, single8, single8));

    TwelveWeightDivider d4 = new TwelveWeightDivider();
    d4.init(ListSequence.fromListAndArray(new ArrayList<TableForm.Column>(), single8, single8, single8, single8));

    TwelveWeightDivider d5 = new TwelveWeightDivider();
    d5.init(ListSequence.fromListAndArray(new ArrayList<TableForm.Column>(), single8, single8, single8, single8, single8));

    TwelveWeightDivider d6 = new TwelveWeightDivider();
    d6.init(ListSequence.fromListAndArray(new ArrayList<TableForm.Column>(), single8, single8, single8, single8, single8, single8));


    System.err.println("\n\n\n--------------------------------\n" + AbstractColumnDivider.printDiv(d1));
    System.err.println("\n\n\n--------------------------------\n" + AbstractColumnDivider.printDiv(d2));
    System.err.println("\n\n\n--------------------------------\n" + AbstractColumnDivider.printDiv(d3));
    System.err.println("\n\n\n--------------------------------\n" + AbstractColumnDivider.printDiv(d4));
    System.err.println("\n\n\n--------------------------------\n" + AbstractColumnDivider.printDiv(d5));
    System.err.println("\n\n\n--------------------------------\n" + AbstractColumnDivider.printDiv(d6));
  }

}
