package org.modellwerkstatt.objectflow.batchjob;

/*Generated by MPS */

import javax.management.NotificationBroadcasterSupport;
import org.modellwerkstatt.objectflow.runtime.IOFXUserServices;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormat;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.objectflow.runtime.IPrintingServiceImpl;
import org.modellwerkstatt.objectflow.runtime.CoreReporterInfo;
import org.modellwerkstatt.objectflow.runtime.MoVersion;
import org.joda.time.DateTime;
import javax.management.Notification;
import java.util.HashMap;
import java.io.File;
import org.modellwerkstatt.objectflow.runtime.OFXShutDownSessionException;
import org.modellwerkstatt.objectflow.runtime.IOFXProblem;

public class JobReporter extends NotificationBroadcasterSupport implements IOFXUserServices {
  public static final int PRODUCER_ID = -1;

  private static final int NUM_ROLLATING_MSG = 40;
  public static DateTimeFormatter EXACT_TIME_ONLY_FORMATTER = DateTimeFormat.forPattern("dd.MMM HH:mm:ss.SSS");

  protected JobProperties props;
  protected int id;
  protected String pcPairName;
  protected String pcPairSource;

  protected IOFXCoreReporter coreReporter;
  protected IPrintingServiceImpl userPrintService;

  private boolean consoleMode;
  private boolean traceEnabled;

  private long sequence;
  private RollatingLogger rollatingLogger;
  private RollatingLogger traceRollatingLogger;


  private int protocollledExceptionCount;
  private int unProtocollledExceptionCount;

  protected String userNameAndId;


  public JobReporter(String aPcPairName, int idOrProducer, JobProperties aProps) {
    sequence = 0;
    protocollledExceptionCount = 0;
    unProtocollledExceptionCount = 0;
    consoleMode = true;

    id = idOrProducer;
    pcPairName = aPcPairName;
    props = aProps;
    userNameAndId = props.userName + "_" + props.userId;
    pcPairSource = (id == PRODUCER_ID ? "PRODUCER" : "CONSUMER " + id);
    pcPairSource += " " + pcPairName;

    rollatingLogger = new RollatingLogger(NUM_ROLLATING_MSG);
    traceRollatingLogger = new RollatingLogger(NUM_ROLLATING_MSG * 2);

    traceEnabled = false;
  }

  public void initUserServices(IPrintingServiceImpl printServiceImp, IOFXCoreReporter reporter) {
    userPrintService = printServiceImp;
    coreReporter = reporter;
  }
  public void consoleModeOff() {
    consoleMode = false;
  }
  public boolean isConsoleMode() {
    return consoleMode;
  }
  protected CoreReporterInfo createInfoObject(IOFXCoreReporter.Type typ, IOFXCoreReporter.LogPriority prio, String desc) {
    CoreReporterInfo info = new CoreReporterInfo(typ, props.swJobFqName, props.swJobVersion, IOFXCoreReporter.EVENT, "", "", prio, props.userId, props.userName, pcPairSource, "" + id, props.systemName, MoVersion.MOWARE_PLUGIN_VERSION, IOFXCoreReporter.MoWarePlatform.MOWARE_JOB, props.systemName, desc);
    return info;
  }

  public void jmxLog(boolean trace, String prio, String msg, Throwable t) {
    String exInfo = "";
    if (t != null) {
      exInfo = " [" + t.getClass().getSimpleName() + " " + t.getMessage() + "]";
    }

    long currentMillis = System.currentTimeMillis();
    String rollLoggerTxtMsg = String.format("%25s %s%s", EXACT_TIME_ONLY_FORMATTER.print(new DateTime(currentMillis)), msg, exInfo);

    if (traceEnabled && trace) {
      traceRollatingLogger.add(rollLoggerTxtMsg);
      if (!(consoleMode)) {
        Notification n = new Notification(prio, this, sequence++, currentMillis, msg + exInfo);
        n.setUserData(userNameAndId);
        sendNotification(n);
      }

    } else if (trace) {
      traceRollatingLogger.add(rollLoggerTxtMsg);

    } else if (!(trace)) {
      rollatingLogger.add(rollLoggerTxtMsg);

      if (!(consoleMode)) {
        Notification n = new Notification(prio, this, sequence++, currentMillis, msg + exInfo);
        n.setUserData(userNameAndId);
        sendNotification(n);

      }

    }
  }

  @Override
  public void logOnCoreReporter(String cmdFqName, String sessId, String source, IOFXCoreReporter.LogPriority prio, String desc, HashMap<String, Object> paramMap) {
    CoreReporterInfo info = createInfoObject(IOFXCoreReporter.Type.APP_MESSAGE, prio, desc);
    info.setCmdFqName(cmdFqName);
    info.setSource(source);

    if (paramMap != null) {
      for (String key : paramMap.keySet()) {
        info.addParameter(key, paramMap.get(key));
      }
    }

    coreReporter.report(info);
    jmxLog(false, "" + prio, desc, null);
  }
  public void logFrmwrkTrace(String msg) {
    CoreReporterInfo info = createInfoObject(IOFXCoreReporter.Type.MOWARE_FRMWRK_TRACE, IOFXCoreReporter.LogPriority.TRACE, msg);
    info.setSource(IOFXCoreReporter.EVENT);

    coreReporter.report(info);
    jmxLog(true, "MOWARE TRACE", msg, null);
  }
  public void logFrmwrkError(String msg, Throwable t) {
    CoreReporterInfo info = createInfoObject(IOFXCoreReporter.Type.MOWARE_FRMWRK_PROBLEM, IOFXCoreReporter.LogPriority.ERROR, msg);
    info.setSource(IOFXCoreReporter.RT);

    info.setException(t);

    coreReporter.report(info);
    jmxLog(false, "ERROR", msg, t);
  }
  public void logJobProblem(boolean alreadyLogged, String desc, Throwable t, String param) {
    protocollledExceptionCount++;

    if (!(alreadyLogged)) {
      CoreReporterInfo info = createInfoObject(IOFXCoreReporter.Type.APP_PROBLEM, IOFXCoreReporter.LogPriority.ERROR, desc);
      info.setException(t);
      if (param != null) {
        info.addParameter(CoreReporterInfo.PARAM, param);
      }
      coreReporter.report(info);
    }
    jmxLog(false, "ERROR", desc, t);
  }

  public void skipReportingEx() {
    unProtocollledExceptionCount++;
  }
  public int getxExceptions_protocolled() {
    return protocollledExceptionCount;
  }
  public int getxExceptions_unprotocolled() {
    return unProtocollledExceptionCount;
  }
  public String fullStatusReport() {
    return rollatingLogger.toString();
  }
  public String fullStatusReportTraceLevel() {
    return traceRollatingLogger.toString();
  }
  public String enableTracing(boolean enabled) {
    traceEnabled = enabled;
    return "Tracing in now " + traceEnabled;
  }


  public File renderPrint(String documentFilename, String xsltTemplateName, String xmlGraphData, Object barcode) {
    // ---> Forward, but be in control <---
    return userPrintService.renderPrint(documentFilename, xsltTemplateName, xmlGraphData, barcode);
  }
  public File renderView(String documentFilename, String xsltTemplateName, String xmlGraphData, Object barcode) {
    return userPrintService.renderView(documentFilename, xsltTemplateName, xmlGraphData, barcode);
  }
  public File render(String documentFilename, String xsltTemplateName, String xmlGraphData, Object barcode) {
    return userPrintService.render(documentFilename, xsltTemplateName, xmlGraphData, barcode);
  }
  public void view(File pdfFile) {
    userPrintService.view(pdfFile);
  }
  public void print(File pdfFile) {
    userPrintService.print(pdfFile);
  }
  public void openUrl(String url) {
    userPrintService.openUrl(url);
  }

  public String assembleJMXPrefix(String pairId, boolean producer, int id) {
    String jobName = props.swJobFqName + "_" + props.swJobVersion.replace(" ", "_").replace(".", "_");
    String[] splittedFqNAme = jobName.split("\\.");
    String assebledJMXNamePrefix = "";

    if (splittedFqNAme.length > 2) {
      splittedFqNAme[0] = splittedFqNAme[0] + "." + splittedFqNAme[1];
      splittedFqNAme[1] = null;
    }

    for (int i = 0; i < splittedFqNAme.length; i++) {
      if (i == 0) {
        assebledJMXNamePrefix += splittedFqNAme[i] + ":";
      } else if (splittedFqNAme[i] != null) {
        assebledJMXNamePrefix += String.format("%02d=%s,", i - 1, splittedFqNAme[i]);
      }

    }
    assebledJMXNamePrefix += "name=";
    if (producer) {
      assebledJMXNamePrefix += pairId + "_Producer";
    } else {
      assebledJMXNamePrefix += pairId + "_Consumer" + id;
    }
    return assebledJMXNamePrefix;
  }

  public String convertGuardMsg(Throwable t) {
    if (t == null) {
      return null;
    }

    if (t instanceof OFXShutDownSessionException) {
      IOFXProblem prblm = ((OFXShutDownSessionException) t).getProblem();
      return prblm.getSimpleUserText();
    } else {
      return t.getMessage();
    }

  }
}
