package org.modellwerkstatt.objectflow.batchjob;

/*Generated by MPS */

import java.util.List;
import org.springframework.scheduling.support.CronSequenceGenerator;
import java.util.ArrayList;
import java.util.TimeZone;
import org.joda.time.DateTime;
import java.util.Date;

public class MultiCronJobDesc {
  public static final int MIN_MILL_DELAY = 1000;

  private List<CronSequenceGenerator> cronSequenceGenerators;
  private List<String> cronExpressions;

  private int delayInMs;
  private int pairId;
  private String pairName;


  public MultiCronJobDesc(int pairCrltId, String pairCrtlName) {
    cronSequenceGenerators = new ArrayList<CronSequenceGenerator>();
    cronExpressions = new ArrayList<String>();
    delayInMs = -1;

    pairId = pairCrltId;
    pairName = pairCrtlName;
  }



  public void addCron(String cronExp) {
    CronSequenceGenerator seq = new CronSequenceGenerator(cronExp, TimeZone.getDefault());
    cronSequenceGenerators.add(seq);
    cronExpressions.add(cronExp);

    if (isCronWindowMode()) {
      throw new RuntimeException("Set cron expressions first, ");
    }

  }

  public void setDelayInMS(int millis) {
    delayInMs = millis;
  }

  public boolean isCronWindowMode() {
    return delayInMs > 0;
  }

  public void checkModeOK() {
    if (!(isCronWindowMode()) && cronExpressions.size() == 0) {
      // dependent - no mode ...

    } else if (isCronWindowMode()) {
      // none or one cron given
      for (int i = 0; i < cronExpressions.size(); i++) {
        if (!(cronExpressions.get(i).startsWith("* "))) {
          throw new RuntimeException("When specifying cron expressions in delay/continous mode, specify a cron window in form of '* * 3-23 * * *' and not '" + cronExpressions.get(i) + "'");
        }
      }

    } else {
      if (cronExpressions.size() <= 0) {
        throw new RuntimeException("A cron expression is necessary, when running in time-specific mode. There are none given currently.");
      }
      for (int i = 0; i < cronExpressions.size(); i++) {
        if (cronExpressions.get(i).startsWith("*")) {
          throw new RuntimeException("When specifying cron expressions in time-specific mode, specify a specific time (starting at a specific sec) in form of '0 0 23 * * *' and not '" + cronExpressions.get(i) + "'");
        }
      }
    }
  }


  public DateTime nextEarlyiestRunMS(int waitingTimeInMs) {
    checkModeOK();
    DateTime dNowPlusWaiting = new DateTime();

    if (isCronWindowMode()) {
      if (waitingTimeInMs <= 0) {
        waitingTimeInMs = delayInMs;

      }

      //  now ...
      dNowPlusWaiting = dNowPlusWaiting.plusMillis(waitingTimeInMs);
      if (cronSequenceGenerators.size() <= 0) {
        return dNowPlusWaiting;

      } else {
        DateTime nextEarliestRun = new DateTime(cronSequenceGenerators.get(0).next(dNowPlusWaiting.toDate()));

        for (int i = 1; i < cronSequenceGenerators.size(); i++) {
          DateTime newDate = new DateTime(cronSequenceGenerators.get(i).next(dNowPlusWaiting.toDate()));
          if (newDate.isBefore(nextEarliestRun)) {
            nextEarliestRun = newDate;
          }
        }
        return nextEarliestRun;
      }

    } else {
      // in time specific mode .... .... .... .... .... ....
      if (waitingTimeInMs > 0) {
        // waiting time given, so rerun in now + waiting time
        dNowPlusWaiting = dNowPlusWaiting.plusMillis(waitingTimeInMs);
        return dNowPlusWaiting;

      } else {
        // no waiting time given. draw from cron
        DateTime nextEarliestRun = new DateTime(cronSequenceGenerators.get(0).next(dNowPlusWaiting.toDate()));

        for (int i = 1; i < cronSequenceGenerators.size(); i++) {
          DateTime newDate = new DateTime(cronSequenceGenerators.get(i).next(dNowPlusWaiting.toDate()));
          if (newDate.isBefore(nextEarliestRun)) {
            nextEarliestRun = newDate;
          }
        }
        return nextEarliestRun;
      }
    }
  }

  public boolean canRunAccoordingToCronWindowInDelayMode(DateTime when) {

    // run allways in specific mode when requested.
    if (!(isCronWindowMode())) {
      return true;
    }

    // no cron given ...
    if (cronSequenceGenerators.size() <= 0) {
      return true;
    }
    // check for cron window ..
    boolean canRun = false;
    for (int i = 0; i < cronSequenceGenerators.size(); i++) {
      DateTime newDate = new DateTime(cronSequenceGenerators.get(i).next(when.toDate()));
      long diff = newDate.getMillis() - when.getMillis();
      // 2 secs diff, that would be ok!
      if (diff < 2000) {
        return true;
      }
    }
    return canRun;
  }

  @Override
  public String toString() {
    String s = "";

    if (isCronWindowMode()) {
      s += "delayMode " + delayInMs + " millis";
    }
    for (int i = 0; i < cronSequenceGenerators.size(); i++) {
      s += cronSequenceGenerators.get(i).toString().replace("CronSequenceGenerator:", "") + ", ";
    }

    return s;
  }

  public int getPairID() {
    return pairId;
  }
  public void checkForCronInDependentMode(boolean first) {
    if (first) {
      if (cronExpressions.size() > 0 || isCronWindowMode()) {
        // okay
      } else {
        throw new RuntimeException("First cronDescriptions needs to be in delay mode or has a cron in dependent mode. cron: " + cronExpressions.size() + " delayMode: " + isCronWindowMode());
      }
    } else {
      if (cronExpressions.size() != 0 || isCronWindowMode()) {
        throw new RuntimeException("CronDesc for pair in dependent mode should not has any configuration!  cron: " + cronExpressions.size() + " delayMode: " + isCronWindowMode());
      }
    }
  }
  public String getPairName() {
    return pairName;
  }


  public static void main(String[] args) {
    CronSequenceGenerator cst = new CronSequenceGenerator("* * 10-21 * * *");
    System.err.println("> " + cst.next(new Date()));
  }

}
