package org.modellwerkstatt.objectflow.batchjob;

/*Generated by MPS */

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.io.File;
import java.util.Scanner;
import java.io.FileNotFoundException;

public class OFXBatchJobHtmlDashboard {
  private static String styles = "<style>   H1 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:22px;} H2 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:16px;} H3 {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;font-size:14px;} BODY {font-family:Tahoma,Arial,sans-serif;color:black;background-color:white;} B {font-family:Tahoma,Arial,sans-serif;color:white;background-color:#525D76;} P {font-family:Tahoma,Arial,sans-serif;background:white;color:black;font-size:12px;}A {color : black;}A.name {color : black;}.line {height: 1px; background-color: #525D76; border: none;}     table {       width: 100%;     }     td.page-title {       text-align: center;       vertical-align: top;       font-family:sans-serif,Tahoma,Arial;       font-weight: bold;       background: white;       color: black;     }     td.title {       text-align: left;       vertical-align: top;       font-family:sans-serif,Tahoma,Arial;       font-style:italic;       font-weight: bold;       background: #D2A41C;     }     td.header-left {       text-align: left;       vertical-align: top;       font-family:sans-serif,Tahoma,Arial;       font-weight: bold;       background: #FFDC75;     }     td.header-center {       text-align: center;       vertical-align: top;       font-family:sans-serif,Tahoma,Arial;       font-weight: bold;       background: #FFDC75;     }     td.row-left {       text-align: left;       vertical-align: middle;       font-family:sans-serif,Tahoma,Arial;       color: black;     }     td.row-center {       text-align: center;       vertical-align: middle;       font-family:sans-serif,Tahoma,Arial;       color: black;     }     td.row-right {       text-align: right;       vertical-align: middle;       font-family:sans-serif,Tahoma,Arial;       color: black;     }     TH {       text-align: center;       vertical-align: top;       font-family:sans-serif,Tahoma,Arial;       font-weight: bold;       background: #FFDC75;     }     TD {       text-align: center;       vertical-align: middle;       font-family:sans-serif,Tahoma,Arial;       color: black;     }     form {       margin: 1;     }     form.inline {       display: inline;     }   </style>";
  private String appName;
  private StringBuilder vars;
  private HttpServletRequest request;

  public OFXBatchJobHtmlDashboard(String applicationName) {
    appName = applicationName;
    vars = new StringBuilder();
  }

  public OFXBatchJobHtmlDashboard(String applicationName, HttpServletRequest req) {
    appName = applicationName;
    vars = new StringBuilder();
    request = req;
  }

  public void addSection(String section) {
    this.addMonitoringInfo("", "");
    this.addMonitoringInfo("<strong><i>" + section.toUpperCase() + "</i></strong>", "");
  }

  public void addMonitoringInfo(String name, String value) {
    vars.append("<tr> <td class=\"row-left\" bgcolor=\"#FFFFFF\"><small>");
    vars.append(name + " </small></td> <td class=\"row-left\" bgcolor=\"#FFFFFF\" ><small>");
    vars.append(value + "</small></td> <td class=\"row-left\" bgcolor=\"#FFFFFF\" ><small>");
    vars.append("        </small></td> <td class=\"row-left\" bgcolor=\"#FFFFFF\" ><small>");
    vars.append("        </small></td> </tr>");
  }

  public String getFQName(String module, String varName) {
    return (module + "." + varName).replace('.', '_').replace(' ', '_').toLowerCase();
  }

  public boolean hasChanged(String module, String varName) {
    String val = this.request.getParameter(getFQName(module, varName));
    if (val != null) {
      return true;
    }
    return false;
  }

  public String getValue(String module, String varName) {
    String val = this.request.getParameter(getFQName(module, varName));
    return val;
  }

  public void addSettingVariable(String moduleName, String name, String value, List<String> options) {
    vars.append("<tr> <td class=\"row-left\" bgcolor=\"#FFFFFF\"><small>");
    vars.append(name + " </small> </td> <td class=\"row-left\" bgcolor=\"#FFFFFF\" ><small>");
    vars.append(value + "</small></td> <td class=\"row-left\" bgcolor=\"#FFFFFF\" ><small>");
    vars.append("        </small></td> <td class=\"row-left\" bgcolor=\"#FFFFFF\" ><small>");

    String postName = getFQName(moduleName, name);

    // form and choicebox with values
    vars.append("<form action=\"\" method=\"post\">");
    vars.append("<select name=\"" + postName + "\">");
    for (String opt : options) {
      vars.append("<option ");
      if (opt.equals(value)) {
        vars.append(" selected ");
      }
      vars.append(" value=\"" + opt + "\"> " + opt + "</option>");
    }
    vars.append("</select>");
    vars.append("&nbsp; &nbsp; <input type=\"submit\" value=\"apply\">");
    vars.append("</form>");

    vars.append("        </small></td> </tr>");
  }

  public String getPage() {
    StringBuilder b = new StringBuilder();
    b.append("<html><head>");
    b.append(styles);
    b.append("</style> <title>OFXBatchjob ADMIN</title> </head> <body bgcolor=\"#FFFFFF\"> ");
    b.append("<br>OFXBatchJob ADMIN<br><br> <hr size=\"1\" noshade=\"noshade\"> <table cellspacing=\"4\" border=\"0\"> <tr>  <td class=\"page-title\" bordercolor=\"#000000\" align=\"left\" nowrap> <font size=\"+2\">");
    b.append(appName + "</font> </td> </tr></table> <br>");
    b.append("<br><br><a href=\".\">RELOAD</a><br>");
    b.append("<a href=\"/\">Server's home (log files).</a><br>");
    b.append("<a href=\"/manager/html\">Server's manager app.</a></br></br>");
    b.append("<table border=\"1\" cellspacing=\"0\" cellpadding=\"3\"> <tr> <td colspan=\"4\" class=\"title\">Monitoring / Config Values</td></tr> <tr><td class=\"header-left\"><small>Variable</small></td><td class=\"header-left\"><small>Value</small></td><td class=\"header-center\"><small>-</small></td> <td class=\"header-center\"><small>-</small></td></tr>");
    b.append(vars.toString());
    b.append("</table>");

    b.append("</body></html>");
    return b.toString();
  }
  public void getFile(File file, StringBuilder buf) {
    try {
      Scanner sc = new Scanner(file);
      while (sc.hasNext()) {
        buf.append(sc.nextLine() + "<br>");
      }
      sc.close();
    } catch (FileNotFoundException ex) {
      buf.append("FileNotFoundException " + ex.getMessage() + "<br><br>");
    }
  }










}
