package org.modellwerkstatt.objectflow.batchjob;

/*Generated by MPS */

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ArrayBlockingQueue;
import org.modellwerkstatt.objectflow.runtime.IPrintingServiceImpl;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import org.modellwerkstatt.manmap.runtime.MMShutdownRequestException;
import org.modellwerkstatt.objectflow.runtime.OFXJobWorkCanceledException;
import org.joda.time.DateTime;

public class OFXConsumerRunnable<EntityOrKey> extends ConsumerReporter implements Runnable {
  private static final int QUEUE_CAPACITY = 15;
  public static final String TEST_STOP_EVENT_LOOP_EX_MSG = "Stop OFXConsumerRunnable EventLoop now!";

  private BlockingQueue<Message> queue;
  private volatile boolean eventLoopRunning;
  private Message currentMessageProcessing;
  private IOFXCommandImplConsumer[] consumerImplementations;


  private OFXPCPairController producer;

  private boolean dbg_ignoreGraceFullyShutdown;
  private boolean dbg_ignoreWorkDoneSend;


  public OFXConsumerRunnable(String pcPairName, int consId, JobProperties props, IOFXCommandImplConsumer[] implementation) {
    super(pcPairName, consId, props);

    queue = new ArrayBlockingQueue<Message>(QUEUE_CAPACITY);
    eventLoopRunning = false;
    dbg_ignoreGraceFullyShutdown = false;
    dbg_ignoreWorkDoneSend = false;
    consumerImplementations = implementation;
  }

  public void init(OFXPCPairController prod, IPrintingServiceImpl printServiceImp, IOFXCoreReporter reporter) {
    producer = prod;
    userPrintService = printServiceImp;
    coreReporter = reporter;
    eventLoopRunning = true;
  }

  public String printQueue() {
    String s = "";
    for (Object obj : queue.toArray()) {
      s += obj.toString() + ", ";
    }
    return s;
  }

  public void receive(Message message) {
    queue.add(message);
  }

  public void run() {
    logFrmwrkTrace("Starting into event loop.");
    // main loop of consumer
    try {
      while (eventLoopRunning) {
        setInternalStatus("Waiting for messages");
        currentMessageProcessing = queue.take();

        logFrmwrkTrace("Processing Message " + currentMessageProcessing);
        setInternalStatus("Processing Message " + currentMessageProcessing);

        if (currentMessageProcessing instanceof ProcessWorkMsg) {
          EntityOrKey ek = ((ProcessWorkMsg<EntityOrKey>) currentMessageProcessing).getEntityKey();
          boolean problem = false;
          try {
            String status = "-";

            startProcessing(ek);
            boolean handled = false;
            for (IOFXCommandImplConsumer imp : consumerImplementations) {
              if (imp.toExecute(ek)) {
                handled = true;
                imp.process(this, ek);
                status = imp.getLastAction();
                setLastAction(status);
                // this is a if, else if ... so only one implementation will run here.
                break;
              }
            }

            if (!(handled)) {
              throw new RuntimeException("Inbox item '" + ek + "' was not handled by one of the consumer commands. This is probably a problem.");
            }
            stopProcessing();

            if (Thread.currentThread().isInterrupted()) {
              // shutdown, thread was interrupted
              logFrmwrkTrace("Thread isInterrupted() in main loop - shutting down");
              eventLoopRunning = false;
              problem = true;
            }

          } catch (MMShutdownRequestException ex) {
            eventLoopRunning = false;
            problem = true;
            // no event to producer, shutdown will be send.

          } catch (OFXJobWorkCanceledException canceEx) {
            String msg = "Work on '" + ek + "' canceled - first Problem: " + canceEx.getFirstProblem();

            OFXExceptionStrategy.Strategy cancelExStrat = producer.exStratFor(canceEx);
            boolean silentLogCancel = cancelExStrat.isSilentNoLog();

            problem = true;
            producer.receive(new ConsWorkCanceledMsg(id, msg));

            canceledProcessing(silentLogCancel, canceEx.getCmdNAme(), canceEx.getSessionProblems());


          } catch (Throwable t) {
            if (t instanceof InterruptedException) {
              Thread.currentThread().interrupt();
              eventLoopRunning = false;
            }

            // for testing purpose
            if (TEST_STOP_EVENT_LOOP_EX_MSG.equals(t.getMessage())) {
              eventLoopRunning = false;
            }

            OFXExceptionStrategy.Strategy exStrategy = producer.exStratFor(t);
            boolean silentLogCancel = exStrategy.isSilentNoLog();

            // still, EVENTLOOP keeps on running
            problem = true;
            if (!(silentLogCancel)) {
              logJobProblem(false, t.getClass().getSimpleName() + " while consumer processing '" + ek + "': handling with " + exStrategy, t, convertGuardMsg(t));

            } else {
              skipReportingEx();

            }
            producer.receive(new ConsWorkExMsg(id, new DateTime(), t, false));
          }

          if (!(problem) && !(dbg_ignoreWorkDoneSend)) {
            // transaction will check for interrupted, resulting in a M3ShutdownRequestE
            producer.receive(new ConsWorkDoneMsg(id));
          }

        } else if (currentMessageProcessing instanceof ShutdownMsg) {
          if (!(dbg_ignoreGraceFullyShutdown)) {
            eventLoopRunning = false;
          }

        } else {
          throw new RuntimeException("Unknown message " + currentMessageProcessing + " sent to consumer.");

        }

      }

    } catch (InterruptedException ex) {
      logFrmwrkTrace("Interrupted Exception in main loop - shutting down");
      // interruption is a shutdown
      Thread.currentThread().interrupt();

    } catch (Throwable t) {
      logFrmwrkError("Exception in main loop - shutting down", t);
      producer.receive(new ConsWorkExMsg(id, new DateTime(), t, true));

    } finally {
      logFrmwrkTrace("consumer shut down, sending ConsumerDownMsg to producer.");
      setInternalStatus("Shutdown");
      producer.receive(new ConsumerFinallyDownMsg(id));
    }

  }


  public void gcClean() {
    queue.clear();
    // ensure producer can receive msg.
  }

}
