package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */

import org.modellwerkstatt.manmap.runtime.MMJodaDateTimeTypeHandler;
import org.modellwerkstatt.manmap.runtime.IM3DatabaseDescription;
import org.springframework.jdbc.core.JdbcTemplate;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.joda.time.LocalDate;
import org.modellwerkstatt.manmap.runtime.MMShutdownRequestException;
import org.springframework.jdbc.core.ResultSetExtractor;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.springframework.dao.DataAccessException;

public class DeprecatedServerDateProvider {
  private static MMJodaDateTimeTypeHandler jodaDateTimeTypeHandler;
  private static IM3DatabaseDescription databaseDescription;
  private static JdbcTemplate template = null;
  public static DateTime fixedDateTime = null;

  private static long lastTimeMillisFromDB = 0;
  private static long lastTimeMillisFromLocal = 0;
  public static long REORGANIZE_TIMESTAMP_FROM_DB_INTERVALL = 10000;


  /**
   * Why is SimpleServerDateProvider a static class right now? 
   * 
   * new_LocalDateFromServer / new_DateTimeFromServer can be used in Entities / ValueObjects / DTOs
   * right now. Instead of injecting dependencies, we are using those static methods. Maybe we have to 
   * refactor that one time, but then, using new() won t be allowed in objects directly, but only in IHasSession 
   * concepts ... 
   */
  @Autowired
  public DeprecatedServerDateProvider(JdbcTemplate tplt, MMJodaDateTimeTypeHandler time, IM3DatabaseDescription desc) {
    jodaDateTimeTypeHandler = time;
    databaseDescription = desc;
    template = tplt;
  }


  public static LocalDate getSqlServerLocalDate() {
    if (Thread.interrupted()) {
      throw new MMShutdownRequestException("getSqlServerLocalDate() - Thread.interrupted()=true, raising ShutDownRequest Exception.");
    }

    // Oh, DateProvider was patched for tests
    if (fixedDateTime != null) {
      return fixedDateTime.toLocalDate();
    }

    return new LocalDate(internalOrganizeMillis());
  }

  public static DateTime getSqlServerDateTime() {
    if (Thread.interrupted()) {
      throw new MMShutdownRequestException("getSqlServerDateTime() - Thread.interrupted()=true, raising ShutDownRequest Exception.");
    }

    // Oh, DateProvider was patched for tests
    if (fixedDateTime != null) {
      return fixedDateTime;
    }
    return new DateTime(internalOrganizeMillis());
  }

  public long getCurrentMillis() {
    // legacy compatibility
    return internalOrganizeMillis();
  }


  private static long internalOrganizeMillis() {
    long currentMillisLocal = System.currentTimeMillis();
    // The Thomas Hauser localMillis advantage optimization

    if (currentMillisLocal - lastTimeMillisFromLocal > REORGANIZE_TIMESTAMP_FROM_DB_INTERVALL) {
      DateTime dtFromDb = (DateTime) template.query(databaseDescription.getTimeStampQuery(), new ResultSetExtractor() {
        public Object extractData(ResultSet p0) throws SQLException, DataAccessException {
          p0.next();
          return jodaDateTimeTypeHandler.getResult(p0, 1);
        }
      });

      lastTimeMillisFromDB = dtFromDb.getMillis();
      lastTimeMillisFromLocal = System.currentTimeMillis();
      return lastTimeMillisFromDB;
    }

    return lastTimeMillisFromDB + currentMillisLocal - lastTimeMillisFromLocal;
  }

  public static void fixServerDatetimeToConstant(DateTime dt) {
    // method called in tests to change runtime to a constant datetime.
    fixedDateTime = dt;
  }


  public static void shutdownAndGcClean() {
    jodaDateTimeTypeHandler = null;
    databaseDescription = null;
    template = null;
  }

}
