package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */

import java.util.List;

public interface IOFXBatchTask extends Runnable {
  /**
   * called from externally to stop this BatchTask (forever)
   */
  void stopRunningAndInterruptThread();
  /**
   * called internally in run loop by programmer, 
   * if true, run onShutDown
   */
  boolean isStopRunning();
  /**
   * the actual task code 
   * 
   * @throws Exception e.g. from run command or datebase 
   */
  void batchTask() throws Exception;

  void addMonitoringInformation(IMonitoringSettingsProvider provider);
  void updateSettings(IMonitoringSettingsProvider provider);

  interface IMonitoringSettingsProvider {
    void addSection(String section);
    void addMonitoringInfo(String varName, String value);
    void addSettingVariable(String moduleName, String name, String value, List<String> options);

    boolean hasChanged(String module, String varName);
    String getValue(String module, String varName);
  }
}
