package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */


/**
 * Basically one could also integrate jmx support here
 * reg / unreg log jmx via IOFXCoreReporter. That would allow access from everywhere
 * without having to distribout jmxreghelpers around the app.
 * 
 */
public interface IOFXCoreReporter {

  String APP = "org.modellwerkstatt.App";
  String LOGIN = "org.modellwerkstatt.Login";
  String EVENT = "org.modellwerkstatt.Event";
  String EB_HANDLER = "org.modellwerkstatt.EbHandler";
  String USER_EX = "org.modellwerkstatt.Exception";
  String LOCKING = "org.modellwerkstatt.Locking";
  String RT = "org.modellwerkstatt.RT";
  String TCN = "org.modellwerkstatt.TCN";
  String DELEGATGECHANGE = "org.modellwerkstatt.DelegateChange";


  void report(CoreReporterInfo cri);

  default boolean sendToPortJ(CoreReporterInfo cri) {
    if (cri.getMsgType() == Type.APP_MESSAGE && (cri.getPrio() == LogPriority.DEBUG || cri.getPrio() == LogPriority.TRACE)) {
      return false;
    }
    return true;
  }

  enum MoWarePlatform {
    MOWARE_H2(),
    MOWARE_VAADIN(),
    MOWARE_FX8(),
    MOWARE_JOB(),
    MOWARE_TURKU(),
    MOWARE_API()
  }
  enum Type {
    MOWARE_FRMWRK_TRACE(),
    MOWARE_FRMWRK_PROBLEM(),
    APP_PROBLEM(),
    APP_MESSAGE(),
    APP_TRACE()
  }
  enum LogPriority {
    FATAL(),
    ERROR(),
    WARN(),
    INFO(),
    DEBUG(),
    TRACE()
  }

}
