package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */


public class JavaStringFromatHelper {
  public static final char[] FLAGS = new char[]{'-', '#', '+', ' ', '0', ',', '('};
  public static final char[] NUMS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
  public static final char DOT = '.';
  public static final char PERCENT = '%';


  public static boolean in(char c, char[] chars) {
    for (char candidate : chars) {
      if (c == candidate) {
        return true;
      }
    }
    return false;
  }

  public static int isFlagsAndPrecission(String candidate) {
    int curPos = 0;
    int len = candidate.length();

    if (curPos >= len) {
      return -1;
    }

    curPos = noneOrMore(curPos, candidate, FLAGS);
    curPos = noneOrMore(curPos, candidate, NUMS);

    if (curPos == -1 || curPos >= len) {
      return -1;
    }
    if (candidate.charAt(curPos) == DOT) {
      // with precission
      curPos++;
      curPos = oneOrMore(curPos, candidate, NUMS);
    }

    return curPos;
  }

  public static int noneOrMore(int start, String candidate, char[] match) {
    if (start == -1) {
      return -1;
    }
    int curPos = start;
    int len = candidate.length();

    while (curPos < len && in(candidate.charAt(curPos), match)) {
      curPos++;
    }

    if (curPos >= len) {
      return -1;
    }
    return curPos;
  }
  public static int oneOrMore(int start, String candidate, char[] match) {
    if (start == -1) {
      return -1;
    }
    int curPos = start;
    int len = candidate.length();

    while (curPos < len && in(candidate.charAt(curPos), match)) {
      curPos++;
    }

    if (start >= len) {
      return -1;
    }
    if (curPos == start) {
      return -1;
    }
    return curPos;
  }

  public static String[] getPercentFormatters(String x) {
    int arraySize = 0;
    int length = x.length();

    boolean lastWasPercent = false;
    for (int i = 0; i < length; i++) {
      if (x.charAt(i) == '%') {
        if (lastWasPercent) {
          // okay, this is an %% we should split this only once.
          // do not increment array size here.
          lastWasPercent = false;

        } else {
          arraySize++;
          lastWasPercent = true;
        }

      } else {
        lastWasPercent = false;
      }

    }
    // and remainder
    arraySize++;

    String[] partsOfString = new String[arraySize];
    int part = 0;
    lastWasPercent = false;
    StringBuilder b = new StringBuilder();

    for (int i = 0; i < length; i++) {
      if (x.charAt(i) == '%') {
        if (lastWasPercent) {
          // okay, this is an %% we should split this only once.
          // do not increment array size here.
          lastWasPercent = false;
          b.append('%');

        } else {
          partsOfString[part] = b.toString();
          b = new StringBuilder();
          part++;
          lastWasPercent = true;
        }

      } else {
        b.append(x.charAt(i));
        lastWasPercent = false;
      }

    }
    partsOfString[part] = b.toString();

    return partsOfString;
  }


  public static void main(String[] args) {
    System.out.println("> " + isFlagsAndPrecission(""));
    System.out.println("> " + isFlagsAndPrecission("-0.00"));
    System.out.println("> " + isFlagsAndPrecission("0-00"));
    System.out.println("> " + isFlagsAndPrecission("-##.00"));
    System.out.println("> " + isFlagsAndPrecission(".%"));
    System.out.println("> " + isFlagsAndPrecission(".2"));
    System.out.println("> " + isFlagsAndPrecission("."));
    System.out.println("> " + isFlagsAndPrecission("nad"));
    System.out.println(" -- " + "Hello Dan".hashCode());


    System.out.println("\n---------------------------- ");
    for (String s : getPercentFormatters("hello world")) {
      System.out.println("  >" + s + "< ");
    }

    System.out.println("\n---------------------------- ");
    for (String s : getPercentFormatters("hello %world")) {
      System.out.println("  >" + s + "< ");
    }

    System.out.println("\n---------------------------- ");
    for (String s : getPercentFormatters("hello %world%")) {
      System.out.println("  >" + s + "< ");
    }

    System.out.println("\n---------------------------- ");
    for (String s : getPercentFormatters("%hello %world%")) {
      System.out.println("  >" + s + "< ");
    }
    System.out.println("\n---------------------------- ");
    for (String s : getPercentFormatters("%hello %%world%")) {
      System.out.println("  >" + s + "< ");
    }



  }


}
