package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */

import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.FilterComponentBuilder;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import java.io.File;
import org.apache.logging.log4j.core.config.Configurator;

public class Log4JProperties {
  private static ConfigurationBuilder<BuiltConfiguration> log4jConfigBuilder;
  private static RootLoggerComponentBuilder rootLoggerBuilder;
  private static boolean mailOrFileOrSpecialInitUsed = false;


  public static void initBuilder(Level lvl) {
    if (log4jConfigBuilder == null) {
      log4jConfigBuilder = ConfigurationBuilderFactory.newConfigurationBuilder();
      rootLoggerBuilder = log4jConfigBuilder.newRootLogger(lvl);
    }
  }
  public static void setLogLevel(String logger, Level level) {
    initBuilder(Level.ERROR);

    LoggerComponentBuilder loggerBuilder = log4jConfigBuilder.newLogger(logger, level);
    log4jConfigBuilder.add(loggerBuilder);
  }


  private static void addlog4jMailProperties(String mailTo, String mailFrom, String server, String subject) {
    initBuilder(Level.ERROR);
    mailOrFileOrSpecialInitUsed = true;

    AppenderComponentBuilder smpt = log4jConfigBuilder.newAppender("mail", "SMTP");
    smpt.addAttribute("subject", subject);
    smpt.addAttribute("to", mailTo);
    smpt.addAttribute("from", mailFrom);
    smpt.addAttribute("smtpHost", server);
    smpt.addAttribute("smtpPort", "25");
    smpt.addAttribute("bufferSize", "0");

    FilterComponentBuilder threshold = log4jConfigBuilder.newFilter("ThresholdFilter", Filter.Result.ACCEPT, Filter.Result.DENY);
    threshold.addAttribute("level", "ERROR");
    smpt.add(threshold);

    log4jConfigBuilder.add(smpt);
    rootLoggerBuilder.add(log4jConfigBuilder.newAppenderRef("mail"));
  }

  private static void addlog4jFileProperties(String outFile) {
    initBuilder(Level.ERROR);
    mailOrFileOrSpecialInitUsed = true;

    AppenderComponentBuilder file = log4jConfigBuilder.newAppender("file", "File");
    file.addAttribute("fileName", outFile);

    LayoutComponentBuilder layout = log4jConfigBuilder.newLayout("PatternLayout");
    layout.addAttribute("pattern", "%d [%t] %p: %m%n");
    file.add(layout);

    log4jConfigBuilder.add(file);
    rootLoggerBuilder.add(log4jConfigBuilder.newAppenderRef("file"));
  }
  private static void addlog4jConsoleProperties() {
    initBuilder(Level.ERROR);

    AppenderComponentBuilder console = log4jConfigBuilder.newAppender("console", "Console");
    console.addAttribute("target", "SYSTEM_OUT");

    LayoutComponentBuilder layout = log4jConfigBuilder.newLayout("PatternLayout");
    layout.addAttribute("pattern", "%d{HH:mm:ss,SSS} %p: %m%n");
    console.add(layout);

    log4jConfigBuilder.add(console);
    rootLoggerBuilder.add(log4jConfigBuilder.newAppenderRef("console"));
  }
  private static void addlog4jTestSuitProperties(String pattern) {
    initBuilder(Level.INFO);
    mailOrFileOrSpecialInitUsed = true;

    AppenderComponentBuilder console = log4jConfigBuilder.newAppender("console", "Console");
    console.addAttribute("target", "SYSTEM_OUT");

    LayoutComponentBuilder layout = log4jConfigBuilder.newLayout("PatternLayout");
    layout.addAttribute("pattern", pattern);
    console.add(layout);

    log4jConfigBuilder.add(console);
    rootLoggerBuilder.add(log4jConfigBuilder.newAppenderRef("console"));

  }


  public static Integer configMailAndFile(String mailTo, String mailFrom, String server, String subject, String outFile) {
    addlog4jFileProperties(outFile);
    addlog4jMailProperties(mailTo, mailFrom, server, subject);
    return new Integer(0);
  }

  public static Integer configMail(String mailTo, String mailFrom, String server, String subject) {
    addlog4jMailProperties(mailTo, mailFrom, server, subject);
    return new Integer(0);
  }

  public static Integer configFile(String outFile) {
    addlog4jFileProperties(outFile);
    return new Integer(0);
  }


  public static Integer configRelativeFile(String outFile) {
    String path = System.getProperty("user.dir");

    if (outFile.startsWith("/") || outFile.startsWith("\\")) {
      path += outFile;
    } else {
      path += File.separator + outFile;
    }

    addlog4jFileProperties(path);
    return new Integer(0);
  }

  public static void initRichClientSetup() {

  }
  public static void endRichClientSetup(boolean forTestSuit) {

    if (!(mailOrFileOrSpecialInitUsed)) {
      if (!(forTestSuit)) {
        addlog4jConsoleProperties();
      } else {
        addlog4jTestSuitProperties("%m%n");
      }

    } else {
      initBuilder(Level.ERROR);
    }

    log4jConfigBuilder.add(rootLoggerBuilder);
    Configurator.reconfigure(log4jConfigBuilder.build());


  }

}
