package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */

import java.util.List;

public class OFXJobWorkCanceledException extends RuntimeException {
  private List<IOFXProblem> allReasons;
  private String commandFqNAme;


  public OFXJobWorkCanceledException(String cmd, List<IOFXProblem> reasons) {
    super("jop work canceled");
    commandFqNAme = cmd;
    allReasons = reasons;
  }

  public String getCmdNAme() {
    return commandFqNAme;
  }
  public List<IOFXProblem> getSessionProblems() {
    return allReasons;
  }

  @Override
  public String getMessage() {
    return this.getFirstProblem().getSimpleUserText();
  }

  public IOFXProblem getFirstProblem() {
    for (IOFXProblem prblm : allReasons) {
      if (!(prblm.isWarningOnly())) {
        return prblm;
      }
    }
    throw new RuntimeException("This can not happen: No problem just warning in session problem state.");
  }

}
