package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */

import java.util.List;
import java.util.ArrayList;
import jetbrains.mps.internal.collections.runtime.ListSequence;

public class OFXList<T extends IOFXRevertableObject> implements IOFXMetaBasis, IOFXRevertableAttribute<OFXList<T>> {
  private boolean enabled = true;
  private boolean optional = false;
  private String label;
  private int hashAfterSet = 0;

  private List<T> currentList = new ArrayList<T>();
  private List<T> originalReferences;


  public OFXList() {
    originalReferences = null;
  }

  protected boolean needCopy() {
    if (currentList != null && currentList.size() >= 1 && currentList.get(0) instanceof IOFXEntity) {
      for (int i = 0; i < currentList.size(); i++) {
        if (!(((IOFXEntity) currentList.get(i)).getReadOnly())) {
          // this is not readyOnly, we do have to copy objects
          return true;
        }
      }

    }
    return false;
  }

  public void setEnabled(boolean enbl) {
    this.enabled = enbl;
  }
  public boolean getEnabled() {
    return this.enabled;
  }
  public void setOptional(boolean opt) {
    this.optional = opt;
  }
  public boolean getOptional() {
    return this.optional;
  }
  public void setLabel(String lbl) {
    this.label = lbl;
  }
  public String getLabel() {
    return this.label;
  }
  public boolean setValue(List<T> val) {

    // first set with non null list changes hash, others not!
    if (val != null && ListSequence.fromList(val).count() > 0 && hashAfterSet == 0) {
      // this is an initial assignment, currentList still zero or not?
      if (currentList != null && currentList.size() > 0 && hashOfList(currentList) != hashOfList(val)) {
        // however, re-sorting things is allowed ... :)

        // some items where added in meantime, the will be removed or overwritten
        // mark this list as dirty
        hashAfterSet = -1;

      } else {
        // not dirty, was nothing, this is the first assigment
        hashAfterSet = hashOfList(val);
      }
    }

    this.currentList = val;
    // no dirty, might even be in readonly state
    return false;
  }
  public List<T> getValue() {
    return this.currentList;
  }
  public int hashOfList(List<T> list) {
    int newHash = 0;
    if (list != null) {
      for (T elm : list) {
        newHash += elm.hashCode();
      }
    }
    return newHash;
  }
  public boolean wasListChanged() {
    boolean same = hashAfterSet == hashOfList(currentList);
    return !(same);
  }
  public void setHashForDirtyChecking() {
    hashAfterSet = hashOfList(currentList);
  }
  public OFXList copy() {
    OFXList newOfxList = new OFXList();
    newOfxList.enabled = this.enabled;
    newOfxList.optional = this.optional;
    newOfxList.label = this.label;
    newOfxList.hashAfterSet = this.hashAfterSet;

    if (this.needCopy()) {
      // WE SHOULD WORK WITH A CACHE HERE, copy of ENTITIES ARE CREATED MULTIPLE TIMES using up mem
      newOfxList.currentList = new ArrayList<T>();
      for (int i = 0; i < this.currentList.size(); i++) {
        newOfxList.currentList.add(this.currentList.get(i).copy());
      }
      // keep original References ..
      newOfxList.originalReferences = new ArrayList<T>();
      newOfxList.originalReferences.addAll(this.currentList);

    } else if (this.currentList == null) {
      // 2023.15 support for null lists
      newOfxList.currentList = null;

    } else {
      // no copy needed ... originalReferences = null
      newOfxList.currentList = new ArrayList<T>();
      newOfxList.currentList.addAll(this.currentList);

    }

    return newOfxList;
  }
  public void load(OFXList<T> cp, boolean fullRevertNotMerge) {
    if (fullRevertNotMerge) {
      this.enabled = cp.enabled;
      this.optional = cp.optional;
      this.label = cp.label;
      this.hashAfterSet = cp.hashAfterSet;

      if (cp.currentList == null) {
        // 2023.15 support for null lists
        this.currentList = null;

      } else if (cp.originalReferences == null) {
        this.currentList.clear();
        this.currentList.addAll(cp.currentList);

      } else {
        this.currentList.clear();
        this.currentList.addAll(cp.originalReferences);
        for (int i = 0; i < this.currentList.size(); i++) {
          this.currentList.get(i).load(cp.currentList.get(i), fullRevertNotMerge);
        }
      }

    } else {
      // this is the merge operation for lists
      // this list is dirty - do not set new hash value
      if (this.currentList != null) {
        this.currentList.clear();
      }

    }


  }

  private Boolean requestFocus;
  public void requestFocus() {
    requestFocus = new Boolean(true);
  }
  public boolean getFocusAndClearIt() {
    if (requestFocus != null && requestFocus.equals(true)) {
      requestFocus = null;
      return true;
    }
    requestFocus = null;
    return false;
  }
  private String validationErrorText;
  @Override
  public void setValidationError(String val) {
    validationErrorText = val;
  }
  @Override
  public String getValidationError() {
    return validationErrorText;
  }
}
