package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import javax.sql.DataSource;
import java.sql.SQLException;

public class OFXSimpleAppFactory implements IOFXApplicationFactory {

  @Autowired
  protected ApplicationContext context;
  @Autowired
  protected DataSource dataSource;
  @Autowired
  protected IOFXPlatform platform;
  private String connectionInfo;

  private boolean mowareTrace = false;
  protected boolean alwaysRollbackSession = false;

  public OFXSimpleAppFactory() {
  }

  public IOFXPlatform getPlatform() {
    return platform;
  }


  public void setMowareTrace(boolean val) {
    mowareTrace = val;
  }
  public boolean getMowareTrace() {
    return mowareTrace;
  }
  public void setPortJ(boolean val) {
    if (val == true) {
      OFXLogger.enablePortJ();
    }
  }
  public boolean getPortJ() {
    return OFXLogger.isEnabledPortJ();
  }
  public void setPortJLocal(boolean val) {
    setPortJ(val);
  }
  public boolean getPortJLocal() {
    return getPortJ();
  }

  public boolean getAlwaysRollbackSession() {
    return alwaysRollbackSession;
  }
  public void setAlwaysRollbackSession(boolean val) {
    alwaysRollbackSession = val;
  }
  public IOFXCmdModule getModuleByInstanceName(String fqName) {
    return (IOFXCmdModule) this.context.getBean(fqName);
  }

  public Object getNewClassInstanceByFQName(String fqName) {
    try {
      ClassLoader cl = this.getClass().getClassLoader();
      Class bean = cl.loadClass(fqName);
      Object instance = this.context.getAutowireCapableBeanFactory().createBean(bean);
      return instance;

    } catch (ClassNotFoundException cnfe) {
      throw new RuntimeException("Class '" + fqName + "' not found!", cnfe);
    }
  }
  public IOFXSession createNewSession(IOFXUserEnvironment userEnv, IOFXUserServices usrServ) {
    if (userEnv == null || usrServ == null) {
      throw new RuntimeException("This can not happen " + userEnv + " / " + usrServ + " - none should be null.");
    }

    OFXSimpleManMapSession session = context.getAutowireCapableBeanFactory().createBean(OFXSimpleManMapSession.class);
    // single user environment, userEnv and userEnvironment should be same anyway
    session.initSession(userEnv, usrServ, alwaysRollbackSession);
    return session;
  }

  public IOFXCommand createNewCommand(Class commandClass) {
    return ((IOFXCommand) context.getAutowireCapableBeanFactory().createBean(commandClass));
  }

  public void report(CoreReporterInfo cri) {
    if (cri.getMsgType() == IOFXCoreReporter.Type.MOWARE_FRMWRK_TRACE && !(mowareTrace)) {

    } else if (getPortJ()) {
      if (this.sendToPortJ(cri)) {
        OFXLogger.logCoreInfoToJOrConsole(cri);
      }

    } else {
      OFXLogger.logCoreInfoToJOrConsole(cri);

    }
  }

  public String getConnectionUrl() {
    if (connectionInfo == null) {
      try {
        connectionInfo = dataSource.getConnection().getMetaData().getURL();
      } catch (SQLException e) {
        connectionInfo = "(not available due to SQLException)";
      }
    }
    return connectionInfo;
  }
}
