package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */

import java.util.List;
import java.lang.reflect.Array;
import jetbrains.mps.internal.collections.runtime.Sequence;

public class OFXStatus<T extends IOFXMetaStatus.IOFXStatusElement<T>> implements IOFXMetaStatus<T>, IOFXRevertableAttribute<OFXStatus<T>> {
  protected boolean optional = false;
  protected boolean enabled = true;
  protected String label;
  protected T defaultStatus;
  protected T[] enabledElements;

  protected T value;

  public OFXStatus(T deflt) {
    this.defaultStatus = deflt;
    this.enabledElements = deflt.getAllStatusElements();
    this.value = deflt;
  }

  public boolean setValue(T val) {
    if (this.value == null) {
      if (val == null) {
        // nothing do to...
      } else {
        this.value = val;
        return true;
      }
    } else if (val == null || !(this.value.equals(val))) {
      this.value = val;
      return true;
    }

    return false;
  }
  public T getValue() {
    return this.value;
  }


  public void load(OFXStatus<T> status, boolean fullRevertNotMerge) {
    if (fullRevertNotMerge) {
      this.enabled = status.enabled;
      this.optional = status.optional;
      this.label = status.label;
      this.enabledElements = status.enabledElements;

    }
    this.value = status.value;

    if (!(this.defaultStatus.equals(status.defaultStatus))) {
      throw new RuntimeException("This can not happen.");
    }
  }

  public OFXStatus<T> copy() {
    OFXStatus<T> obj = new OFXStatus<T>(defaultStatus);
    obj.enabled = this.enabled;
    obj.optional = this.optional;
    obj.label = this.label;
    obj.value = this.value;
    obj.enabledElements = this.enabledElements;

    return obj;
  }




  public void setElementsNotTypeSafe(List<T> statusElements) {
    // quite complicated, since toArray(defaultStatus) does not work here.
    enabledElements = ((T[]) Array.newInstance(defaultStatus.getClass(), statusElements.size()));
    for (int i = 0; i < statusElements.size(); i++) {
      enabledElements[i] = statusElements.get(i);
    }
  }
  public T[] getElements() {
    return enabledElements;
  }
  public T[] getAllElements() {
    return defaultStatus.getAllStatusElements();
  }
  public boolean isElementEnabled(T status) {
    for (T elem : enabledElements) {
      if (elem.equals(status)) {
        return true;
      }
    }
    return false;
  }
  public void enableElementsByDBValue(String databaseValues) {
    String[] options = databaseValues.split(",");
    T[] elements = ((T[]) Array.newInstance(defaultStatus.getClass(), options.length));

    for (int i = 0; i < options.length; i++) {
      final String dbValue = options[i].trim();
      T elem = Sequence.fromIterable(Sequence.fromArray(defaultStatus.getAllStatusElements())).findFirst((it) -> it.getDbValue().equals(dbValue));
      if (elem == null) {
        throw new RuntimeException("No Element with db-value '" + dbValue + "' found for status " + defaultStatus.getClass().getName() + ".");
      }
      elements[i] = elem;
    }
    enabledElements = elements;
  }
  public void setElements(T... statusObject) {
    enabledElements = statusObject;
  }
  public void setAllElements() {
    enabledElements = getAllElements();
  }
  public boolean getEnabled() {
    return enabled;
  }
  public boolean getOptional() {
    return optional;
  }
  public void setEnabled(boolean val) {
    enabled = val;
  }
  public void setOptional(boolean val) {
    optional = val;
  }
  public void setLabel(String lbl) {
    this.label = lbl;
  }
  public String getLabel() {
    return this.label;
  }

  private Boolean requestFocus;
  public void requestFocus() {
    requestFocus = new Boolean(true);
  }
  public boolean getFocusAndClearIt() {
    if (requestFocus != null && requestFocus.equals(true)) {
      requestFocus = null;
      return true;
    }
    requestFocus = null;
    return false;
  }
  private String validationErrorText;
  @Override
  public void setValidationError(String val) {
    validationErrorText = val;
  }
  @Override
  public String getValidationError() {
    return validationErrorText;
  }

}
