package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */

import java.util.List;
import java.lang.reflect.Array;
import jetbrains.mps.internal.collections.runtime.Sequence;

public class OFXStatusVP<T extends IOFXMetaStatus.IOFXStatusElement<T>> extends OFXVPBase<T> implements IOFXMetaStatus<T>, IOFXRevertableAttribute<OFXStatusVP<T>> {
  protected T defaultStatus;
  protected T[] enabledElements;


  public OFXStatusVP(T deflt) {
    super();
    defaultStatus = deflt;
    enabledElements = deflt.getAllStatusElements();
  }


  public void load(OFXStatusVP<T> status, boolean fullRevertNotMerge) {
    if (fullRevertNotMerge) {
      this.enabled = status.enabled;
      this.optional = status.optional;
      this.label = status.label;
      this.enabledElements = status.enabledElements;

    }

    if (!(this.defaultStatus.equals(status.defaultStatus))) {
      throw new RuntimeException("This can not happen.");
    }
  }

  public OFXStatusVP<T> copy() {
    OFXStatusVP<T> obj = new OFXStatusVP<T>(defaultStatus);
    obj.enabled = this.enabled;
    obj.optional = this.optional;
    obj.label = this.label;
    obj.enabledElements = this.enabledElements;
    return obj;
  }

  public void setElementsNotTypeSafe(List<T> statusElements) {
    // quite complicated, since toArray(defaultStatus) does not work here.
    enabledElements = ((T[]) Array.newInstance(defaultStatus.getClass(), statusElements.size()));
    for (int i = 0; i < statusElements.size(); i++) {
      enabledElements[i] = statusElements.get(i);
    }
  }
  public T[] getElements() {
    return enabledElements;
  }
  public T[] getAllElements() {
    return defaultStatus.getAllStatusElements();
  }
  public boolean isElementEnabled(T status) {
    for (T elem : enabledElements) {
      if (elem.equals(status)) {
        return true;
      }
    }
    return false;
  }
  public void enableElementsByDBValue(String databaseValues) {
    String[] options = databaseValues.split(",");
    T[] elements = ((T[]) Array.newInstance(defaultStatus.getClass(), options.length));

    for (int i = 0; i < options.length; i++) {
      final String dbValue = options[i].trim();
      T elem = Sequence.fromIterable(Sequence.fromArray(defaultStatus.getAllStatusElements())).findFirst((it) -> it.getDbValue().equals(dbValue));
      if (elem == null) {
        throw new RuntimeException("No Element with db-value '" + dbValue + "' found for status " + defaultStatus.getClass().getName() + ".");
      }
      elements[i] = elem;
    }
    enabledElements = elements;
  }
  public void setElements(T... statusObject) {
    enabledElements = statusObject;
  }
  public String getShortText(T status) {
    return status.getShortDesc();
  }
  public String getLongText(T status) {
    return status.getLongDesc();
  }
  public String getDBText(T status) {
    return status.getDbValue();
  }
  public void setAllElements() {
    enabledElements = getAllElements();
  }

  private String validationErrorText;
  @Override
  public void setValidationError(String val) {
    validationErrorText = val;
  }
  @Override
  public String getValidationError() {
    return validationErrorText;
  }

}
