package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */

import org.springframework.beans.factory.InitializingBean;
import java.text.DecimalFormat;
import org.joda.time.format.DateTimeFormatter;
import java.util.Map;
import java.math.BigDecimal;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.HashMap;
import java.io.FileReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.ArrayList;

public class OFXStringFormatter2 implements IOFXTranslationProvider, InitializingBean {
  public static final String NULL_STRING = "#NULL?";
  public static IOFXTranslationProvider GLOBAL_INSTANCE_DEFAULT_LANG = null;

  public static final String DEFAULT_LOCALE = "de";
  public static final String DATETIME_DELEGATE_EDITOR_PTRN = "dd.MM.yy HH:mm";

  /**
   * Status format: 
   * %st   - status long description       (null is translated to "")
   * %sts  - status short description      (null is translated to "")
   * %stdb - status db value               (null is translated to "")
   * 
   * Use %0d or %0s to force integer or decimal conversions
   */
  private String bigDecimalFormat = "#,##0.00";
  public void setBigDecimalFormat(String frmt) {
    // %bd
    bigDecimalFormat = frmt;
  }

  private String dateTimeFormat = "dd.MM.yyyy HH:mm:ss";
  public void setDateTimeFormat(String frmt) {
    // %dt
    dateTimeFormat = frmt;
  }

  private String timeDateTimeFormat = "HH:mm";
  public void setTimeDateTimeFormat(String frmt) {
    // %tdt
    timeDateTimeFormat = frmt;
  }

  private String localDateFormat = "dd.MM.yy";
  public void setLocalDateFormat(String frmt) {
    // %ld
    localDateFormat = frmt;
  }

  private String shortLocalDateFormat = "dd.MMM";
  public void setShortLocalDateFormat(String frmt) {
    // %sld
    shortLocalDateFormat = frmt;
  }

  public void setTranslationCsvFileAbsolute(String absolutePathNFile) {
    relativeFileLocationClass = null;
    pathToFile = absolutePathNFile;
  }
  public void setTranslationCsvFileRelative(String classFqName, String relativePathnFile) {
    relativeFileLocationClass = classFqName;
    pathToFile = relativeFileLocationClass;
  }
  public void setLocaleForTranslation(String locale) {
    // translation has to be trans_0, trans_1, etc, etc.
    checkAndAddLocale(locale);
  }








  public OFXStringFormatter2() {
  }

  public static final String[] FORMAT_KEYS_MOWARE = {"st", "sts", "stdb", "dt", "ld", "sld", "tdt", "bd"};
  public static final char[] FORMAT_KEYS_SINGLE = {'d', 's', 'f', 'c', 'o', 'x'};
  private DecimalFormat[] bigDecimalFormatter;
  private DateTimeFormatter[] dateTimeFormatter;
  private DateTimeFormatter[] timeDateTimeFormatter;
  private DateTimeFormatter[] localDateFormatter;
  private DateTimeFormatter[] shortLocalDateFormatter;
  private DateTimeFormatter[] delegateDateTimeEditorFormatter;

  private Map<Integer, String[]> translationMap = null;
  private String pathToFile = null;
  private String relativeFileLocationClass = null;



  public String translate(int lang, String formatString, Object... args) {
    // Design principles
    // (1) also used internally, so we can not rely on a generator but check things at runtime
    // (2) quite complex, but only bd has to be replaced by
    // .. look up formatString ..
    formatString = translateSingle(lang, formatString);

    String[] splitted = JavaStringFromatHelper.getPercentFormatters(formatString);
    StringBuilder result = new StringBuilder();
    int argsCnt = -1;
    int argsLength = args.length;
    int startOffset = 0;


    result.append(splitted[0]);
    for (int i = 1; i < splitted.length; i++) {
      String toConvert = splitted[i];

      // Status handling ...
      if (toConvert.startsWith("bd")) {
        // big decimal without format specification
        result.append("%s" + toConvert.substring(2));

        argsCnt++;
        ensureArgAvailabel(argsCnt, argsLength);

        if (args[argsCnt] instanceof BigDecimal) {
          args[argsCnt] = bigDecimalFormatter[lang + 1].format(args[argsCnt]);

        } else if (args[argsCnt] == null) {
          args[argsCnt] = NULL_STRING;

        } else {
          throw new RuntimeException(errorArgExpected(formatString, "BigDecimal", argsCnt, args));
        }
        // -- -- -- -- -- -- -- -- -- --



      } else if (toConvert.startsWith("st") || toConvert.startsWith("sts") || toConvert.startsWith("stdb")) {

        argsCnt++;
        ensureArgAvailabel(argsCnt, argsLength);
        if (args[argsCnt] == null) {
          args[argsCnt] = NULL_STRING;

          if (toConvert.startsWith("stdb")) {
            result.append("%s" + toConvert.substring(4));
          } else if (toConvert.startsWith("sts")) {
            result.append("%s" + toConvert.substring(3));
          } else if (toConvert.startsWith("st")) {
            result.append("%s" + toConvert.substring(2));
          } else {
            throw new RuntimeException("This can not happen.");
          }

        } else if (args[argsCnt] instanceof IOFXMetaStatus.IOFXStatusElement) {
          if (toConvert.startsWith("stdb")) {
            result.append("%s" + toConvert.substring(4));
            args[argsCnt] = ((IOFXMetaStatus.IOFXStatusElement) args[argsCnt]).getDbValue();
          } else if (toConvert.startsWith("sts")) {
            result.append("%s" + toConvert.substring(3));
            args[argsCnt] = ((IOFXMetaStatus.IOFXStatusElement) args[argsCnt]).getShortDesc();
          } else if (toConvert.startsWith("st")) {
            result.append("%s" + toConvert.substring(2));
            args[argsCnt] = ((IOFXMetaStatus.IOFXStatusElement) args[argsCnt]).getLongDesc();
          } else {
            throw new RuntimeException("This can not happen.");
          }

        } else {
          throw new RuntimeException(errorArgExpected(formatString, "Status", argsCnt, args));
        }
        // -- -- -- -- -- -- -- -- -- --


      } else if (toConvert.startsWith("sld")) {
        result.append("%s" + toConvert.substring(3));

        argsCnt++;
        ensureArgAvailabel(argsCnt, argsLength);

        if (args[argsCnt] instanceof ReadableInstant) {
          args[argsCnt] = shortLocalDateFormatter[lang + 1].print(((ReadableInstant) args[argsCnt]));

        } else if (args[argsCnt] instanceof ReadablePartial) {
          args[argsCnt] = shortLocalDateFormatter[lang + 1].print(((ReadablePartial) args[argsCnt]));

        } else if (args[argsCnt] == null) {
          args[argsCnt] = NULL_STRING;

        } else {
          throw new RuntimeException(errorArgExpected(formatString, "LocalDate/Datetime", argsCnt, args));
        }
        // -- -- -- -- -- -- -- -- -- --

        // Fix due to java 11 migration. check length
        if (shortLocalDateFormat.endsWith(".MMM")) {
          String printed = ((String) args[argsCnt]);
          if (!(NULL_STRING.equals(printed))) {
            int start = printed.indexOf(".");
            if (printed.length() > start + 4) {
              args[argsCnt] = printed.substring(0, start + 4);
            }
          }
        }

      } else if (toConvert.startsWith("ld")) {
        result.append("%s" + toConvert.substring(2));

        argsCnt++;
        ensureArgAvailabel(argsCnt, argsLength);

        if (args[argsCnt] instanceof ReadableInstant) {
          args[argsCnt] = localDateFormatter[lang + 1].print(((ReadableInstant) args[argsCnt]));

        } else if (args[argsCnt] instanceof ReadablePartial) {
          args[argsCnt] = localDateFormatter[lang + 1].print(((ReadablePartial) args[argsCnt]));

        } else if (args[argsCnt] == null) {
          args[argsCnt] = NULL_STRING;

        } else {
          throw new RuntimeException(errorArgExpected(formatString, "LocalDate/Datetime", argsCnt, args));
        }
        // -- -- -- -- -- -- -- -- -- --


      } else if (toConvert.startsWith("tdt")) {
        result.append("%s" + toConvert.substring(3));

        argsCnt++;
        ensureArgAvailabel(argsCnt, argsLength);

        if (args[argsCnt] instanceof ReadableInstant) {
          args[argsCnt] = timeDateTimeFormatter[lang + 1].print(((ReadableInstant) args[argsCnt]));

        } else if (args[argsCnt] instanceof ReadablePartial) {
          args[argsCnt] = timeDateTimeFormatter[lang + 1].print(((ReadablePartial) args[argsCnt]));

        } else if (args[argsCnt] == null) {
          args[argsCnt] = NULL_STRING;

        } else {
          throw new RuntimeException(errorArgExpected(formatString, "LocalDate/Datetime", argsCnt, args));
        }
        // -- -- -- -- -- -- -- -- -- --


      } else if (toConvert.startsWith("dt")) {
        result.append("%s" + toConvert.substring(2));

        argsCnt++;
        ensureArgAvailabel(argsCnt, argsLength);

        if (args[argsCnt] instanceof ReadableInstant) {
          args[argsCnt] = dateTimeFormatter[lang + 1].print(((ReadableInstant) args[argsCnt]));

        } else if (args[argsCnt] instanceof ReadablePartial) {
          args[argsCnt] = dateTimeFormatter[lang + 1].print(((ReadablePartial) args[argsCnt]));

        } else if (args[argsCnt] == null) {
          args[argsCnt] = NULL_STRING;

        } else {
          throw new RuntimeException(errorArgExpected(formatString, "LocalDate/Datetime", argsCnt, args));
        }
        // -- -- -- -- -- -- -- -- -- --


      } else if (toConvert.startsWith("n")) {
        result.append("%n");

      } else if (toConvert.startsWith("%")) {
        result.append("%%" + toConvert.substring(1));

      } else if ((startOffset = JavaStringFromatHelper.isFlagsAndPrecission(toConvert)) >= 0) {

        argsCnt++;
        ensureArgAvailabel(argsCnt, argsLength);


        // bd, d, f, s, c, o, x
        String convertedFormat = "%";
        if (startOffset == 1 && (toConvert.startsWith("0s") || toConvert.startsWith("0d"))) {
          // do not take over the zero
        } else {
          convertedFormat += toConvert.substring(0, startOffset);
        }

        String remainder = toConvert.substring(startOffset);
        if (remainder.startsWith("bd")) {
          convertedFormat += "f" + remainder.substring(2);

        } else if (JavaStringFromatHelper.in(remainder.charAt(0), FORMAT_KEYS_SINGLE)) {
          convertedFormat += remainder;

        } else {
          throw new RuntimeException("FlagsAndPrecession (offset " + startOffset + "): It is unclear how we should handle '%" + toConvert + "' as formatString");
        }

        // check params after format was checked... 
        if (args[argsCnt] == null) {
          args[argsCnt] = NULL_STRING;
          result.append("%s");

        } else if (args[argsCnt] instanceof ReadableInstant || args[argsCnt] instanceof ReadablePartial) {
          throw new RuntimeException(errorArgExpected(formatString, "Int/BigDeci/String", argsCnt, args));

        } else {
          result.append(convertedFormat);
        }



      } else {
        throw new RuntimeException("Completely unclear how we should handle the partial format string '%" + toConvert + "'.");
      }
    }


    return String.format(result.toString(), args);
  }

  public String translateSingle(int lang, String label) {
    if (lang < 0) {
      return label;
    }

    int hashCode = label.hashCode();
    if (translationMap != null && translationMap.containsKey(hashCode)) {
      String[] transLations = translationMap.get(hashCode);
      int index = lang + 3;
      if (index < transLations.length) {
        return transLations[index];
      }
    }

    return label;
  }

  public boolean providesTranslationKey(String key) {
    if (translationMap != null && translationMap.containsKey(key.hashCode())) {
      return true;
    }
    return false;
  }

  public DecimalFormat getDecimalFormatter(int langIndex, String formatOrNull) {
    if (formatOrNull == null || "".equals(formatOrNull.trim()) || MoWareFormattersFactory.NO0_FORMAT_OPTION.equals(formatOrNull)) {
      return bigDecimalFormatter[langIndex + 1];
    }
    return MoWareFormattersFactory.forDecimalFormatPattern(formatOrNull, ListSequence.fromList(indexAndLocale).getElement(langIndex + 1));
  }
  public String getDefaultDecimalFormat() {
    return bigDecimalFormat;
  }
  public DecimalFormat getIntegerFormatterOrNull(int langIndex, String formatOrNull) {
    if (formatOrNull == null || "".equals(formatOrNull.trim()) || MoWareFormattersFactory.NO0_FORMAT_OPTION.equals(formatOrNull.trim())) {
      return null;
    }
    return MoWareFormattersFactory.forDecimalFormatPattern(formatOrNull, ListSequence.fromList(indexAndLocale).getElement(langIndex + 1));
  }

  public DateTimeFormatter getLocalDateFormatter(int langIndex, String formatOrNull) {
    if (formatOrNull == null || "".equals(formatOrNull.trim())) {
      return localDateFormatter[langIndex + 1];
    }
    return MoWareFormattersFactory.forDateTimePattern(formatOrNull, ListSequence.fromList(indexAndLocale).getElement(langIndex + 1));
  }
  public String getDefaultLocalDateFormat() {
    return localDateFormat;
  }

  public DateTimeFormatter getDelegateDateTimeEditorFormatter(int langIndex, String formatOrNull) {
    if (formatOrNull == null || "".equals(formatOrNull.trim())) {
      return delegateDateTimeEditorFormatter[langIndex + 1];
    }
    return MoWareFormattersFactory.forDateTimePattern(formatOrNull, ListSequence.fromList(indexAndLocale).getElement(langIndex + 1));
  }
  public String getDefaultDelegateDateTimeEditorFormat() {
    return DATETIME_DELEGATE_EDITOR_PTRN;
  }

  public Map<Integer, String> getStatusTranslationMap(int langIndex, IOFXMetaStatus.IOFXStatusElement<? extends IOFXMetaStatus.IOFXStatusElement> statusElement, boolean longDesc) {
    Map<Integer, String> translations = new HashMap<Integer, String>();
    for (IOFXMetaStatus.IOFXStatusElement elem : statusElement.getAllStatusElements()) {
      if (longDesc) {
        translations.put(elem.getDbValue().hashCode(), translateSingle(langIndex, elem.getLongDesc()));

      } else {
        translations.put(elem.getDbValue().hashCode(), translateSingle(langIndex, elem.getShortDesc()));

      }
    }
    return translations;
  }

  private void ensureArgAvailabel(int cur, int argsLenght) {
    if (cur >= argsLenght) {
      throw new RuntimeException("Expecting to format argument " + (cur + 1) + " but we have only " + argsLenght + " in total.");
    }
  }

  private String errorArgExpected(String formatString, String type, int argsCnt, Object... args) {
    return type + " is required, but argument no. " + argsCnt + " given is (" + args[argsCnt] + ") for '" + formatString + "'";
  }


  public void afterPropertiesSet() {
    // (1) initialize locales
    ListSequence.fromList(indexAndLocale).insertElement(0, OFXStringFormatter2.DEFAULT_LOCALE);
    int transCnt = ListSequence.fromList(indexAndLocale).count();

    bigDecimalFormatter = new DecimalFormat[transCnt];
    dateTimeFormatter = new DateTimeFormatter[transCnt];
    timeDateTimeFormatter = new DateTimeFormatter[transCnt];
    localDateFormatter = new DateTimeFormatter[transCnt];
    shortLocalDateFormatter = new DateTimeFormatter[transCnt];
    delegateDateTimeEditorFormatter = new DateTimeFormatter[transCnt];



    for (int i = 0; i < transCnt; i++) {

      bigDecimalFormatter[i] = MoWareFormattersFactory.forDecimalFormatPattern(bigDecimalFormat, ListSequence.fromList(indexAndLocale).getElement(i));
      dateTimeFormatter[i] = MoWareFormattersFactory.forDateTimePattern(dateTimeFormat, ListSequence.fromList(indexAndLocale).getElement(i));
      timeDateTimeFormatter[i] = MoWareFormattersFactory.forDateTimePattern(timeDateTimeFormat, ListSequence.fromList(indexAndLocale).getElement(i));
      localDateFormatter[i] = MoWareFormattersFactory.forDateTimePattern(localDateFormat, ListSequence.fromList(indexAndLocale).getElement(i));
      shortLocalDateFormatter[i] = MoWareFormattersFactory.forDateTimePattern(shortLocalDateFormat, ListSequence.fromList(indexAndLocale).getElement(i));
      delegateDateTimeEditorFormatter[i] = MoWareFormattersFactory.forDateTimePattern(DATETIME_DELEGATE_EDITOR_PTRN, ListSequence.fromList(indexAndLocale).getElement(i));
    }

    // now check how we should load translations
    try {
      if (relativeFileLocationClass == null && pathToFile != null) {
        acutallyLoadIt(new FileReader(new File(pathToFile)));

      } else if (relativeFileLocationClass != null && pathToFile != null) {
        Class<?> classDef = Class.forName(relativeFileLocationClass);
        InputStream stream = classDef.getResourceAsStream(pathToFile);
        acutallyLoadIt(new InputStreamReader(stream));

      }

    } catch (FileNotFoundException e) {
      throw new RuntimeException(e);
    } catch (IOException e) {
      throw new RuntimeException(e);
    } catch (ClassNotFoundException e) {
      throw new RuntimeException(e);
    }

    GLOBAL_INSTANCE_DEFAULT_LANG = this;
  }

  private void acutallyLoadIt(Reader reader) throws IOException {
    CSVReader csvReader = new CSVReader(reader);

    List<String[]> allLines = csvReader.readAll();
    translationMap = new HashMap<Integer, String[]>();
    for (String[] line : allLines) {
      if (line.length < 3) {
        throw new RuntimeException("Expected format is: <orig-text>, <origin of text>, <mps code>, trans_0, trans_1 etc. Here we have: " + printArray(line));
      }
      translationMap.put(line[0].hashCode(), line);

      // additional validation, 0 is default locale
      if (line.length > (3 + (ListSequence.fromList(indexAndLocale).count() - 1))) {
        throw new RuntimeException("Seems that there are " + (line.length - 3) + " translation(s), but only " + (ListSequence.fromList(indexAndLocale).count() - 1) + " locales defined.");
      }
    }

    csvReader.close();
    reader.close();
  }

  private List<String> indexAndLocale = ListSequence.fromList(new ArrayList<String>());
  private void checkAndAddLocale(String locale) {
    // translations are trans_0, trans_1 etc.
    // workaround for spring ioc property setting, use just one param :)
    String val = "trans_" + ListSequence.fromList(indexAndLocale).count();


    int lang = -1;
    if (val == null) {
      throw new RuntimeException("Do not set Language to null");
    }
    if (!(val.startsWith("trans_"))) {
      throw new RuntimeException("Languages can be set to 'trans_<xxx>' only. You specified an illegal lang label: " + val);
    }

    try {
      lang = Integer.parseInt(val.substring(6));
    } catch (Exception e) {
      throw new RuntimeException("Languages can be set to 'trans_<xxx>' only. You specified an illegal integer suffix: " + val);
    }

    if (lang != ListSequence.fromList(indexAndLocale).count()) {
      throw new RuntimeException("You have to set the locale one by one, starting with index 0. You provided index " + lang + " and there are " + ListSequence.fromList(indexAndLocale).count() + " already registered.");
    }

    ListSequence.fromList(indexAndLocale).addElement(locale);
  }

  private static String printArray(String[] ar) {
    StringBuilder sb = new StringBuilder();
    for (String s : ar) {
      sb.append(s + ", ");
    }
    return sb.toString();
  }


  public static void someMain(String[] args) {
    System.err.println(" my value is " + MoWareFormattersFactory.forDecimalFormatPattern("#,##0.00", "de").format(new BigDecimal("4711.03")));
  }
}
