package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */

import java.util.List;
import java.util.Arrays;
import java.util.ArrayList;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;

public class Selection<T> implements IOFXSelection<T> {
  protected List<T> selectedObjects;
  protected Class typeOfT;
  protected int issuedComponent;

  public Selection(Class type, List<T> objects) {
    typeOfT = type;
    selectedObjects = objects;
    issuedComponent = this.hashCode();
  }

  public Selection(Class type, T[] objects) {
    typeOfT = type;
    selectedObjects = Arrays.asList(objects);
  }
  public Selection(T object) {
    typeOfT = object.getClass();
    selectedObjects = new ArrayList<T>();
    selectedObjects.add(object);
  }
  public Selection(Class objectType) {
    typeOfT = objectType;
    selectedObjects = new ArrayList<T>();
  }
  public void setIssuer(int hashCode) {
    // used if a framework want s to work with 'from' logic
    issuedComponent = hashCode;
  }
  public int getIssuer() {
    // used if a framework want s to work with 'from' logic
    return issuedComponent;
  }
  public boolean isEmpty() {
    return selectedObjects.size() == 0;
  }
  public boolean isSingleObject() {
    if (selectedObjects.size() == 1) {
      return true;
    }
    return false;
  }
  public T getObject() {
    if (selectedObjects.size() != 1) {
      throw new IllegalArgumentException("More than one or none " + typeOfT.getName() + " were selected, although only one was expected!");
    }
    return selectedObjects.get(0);
  }
  public T getObjectOrNull() {
    if (selectedObjects.size() != 1) {
      return null;
    }
    return selectedObjects.get(0);
  }
  public List<T> getObjects() {
    return selectedObjects;
  }
  public boolean isContainedIn(List<T> containedList) {
    boolean noFasterMethod = ListSequence.fromList(containedList).containsSequence(ListSequence.fromList(this.selectedObjects));
    return noFasterMethod;
  }
  public void setObject(T object) {
    selectedObjects = new ArrayList<T>();
    selectedObjects.add(object);
  }
  public void setObjects(List<T> objects) {
    if (!(objects.get(0).getClass().equals(typeOfT))) {
      // remove? according to constructor, setting any list is possible. used in tables with derived objs. 
      throw new IllegalArgumentException("Setting object list with wrong type " + objects.get(0).getClass().getName() + "  expected  " + typeOfT.getName());
    }
    selectedObjects = objects;
  }
  public int size() {
    return selectedObjects.size();
  }
  public Class getType() {
    return typeOfT;
  }
  @Override
  public boolean equals(Object otherSelectionUnCast) {
    if (!(otherSelectionUnCast instanceof Selection)) {
      return false;
    }
    if (otherSelectionUnCast == null) {
      return false;
    }
    Selection otherSelection = (Selection) otherSelectionUnCast;
    if (this.size() != otherSelection.size()) {
      return false;
    }
    if (!(this.getType().equals(otherSelection.getType()))) {
      return false;
    }

    for (int i = 0; i < size(); i++) {
      if (!(SaveObjectComperator.equals(this.selectedObjects.get(i), otherSelection.selectedObjects.get(i)))) {
        return false;
      }
    }

    return true;
  }
  public boolean equalsList(List<T> objects) {
    if (ListSequence.fromList(objects).count() != this.selectedObjects.size()) {
      return false;
    }

    for (final Wrappers._int i = new Wrappers._int(0); i.value < this.selectedObjects.size(); i.value++) {
      if (!(ListSequence.fromList(objects).any((it) -> it.equals(Selection.this.selectedObjects.get(i.value))))) {
        return false;
      }
    }
    return true;
  }
  @Override
  public String toString() {
    if (typeOfT == null) {
      return "";
    }
    return "(" + selectedObjects.size() + " * " + typeOfT.getName() + ")";
  }
  public static IOFXSelection convertObject2Selection(Object obj) {
    if (obj instanceof List) {
      // if selection with list, but size is 0 ... no selection !
      if (((List) obj).size() > 0) {
        return new Selection(((List) obj).get(0).getClass(), ((List) obj));
      } else {
        return null;
      }
    }
    if (obj != null) {
      return new Selection(obj);
    }
    return null;
  }
}
