package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */


public class TelemetricsLongAbsoluter {
  private long maxValue;
  private long meanValue;
  private long nCount;

  public TelemetricsLongAbsoluter() {
    maxValue = 0;
    meanValue = 0;
    nCount = 0;
  }

  public synchronized void addSample(long smpl) {
    meanValue = (meanValue * nCount + smpl) / (nCount + 1);
    nCount++;
    if (smpl > maxValue) {
      maxValue = smpl;
    }
  }

  public long getAverage() {
    return meanValue;
  }
  public long getMax() {
    return maxValue;
  }
  public long getCount() {
    return nCount;
  }




  public static void main(String[] args) {
    TelemetricsLongAbsoluter m = new TelemetricsLongAbsoluter();
    m.addSample(10);
    m.addSample(30);
    m.addSample(20);

    System.out.println("" + m.getMax());
    System.out.println("" + m.getAverage());
    System.out.println("" + m.getCount());
  }
}
