package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */

import java.util.Map;
import java.util.HashMap;

public class UserEnvironmentInformation implements IOFXUserEnvironment {

  private int uid = 0;
  private String username = "(no username)";
  private String dynamicStatusInfo = "";
  private int lang = -1;
  private String langAsString = "";
  private boolean appCompactMode = false;
  private Map<Integer, Boolean> cachedRoles;
  private Map<Integer, Object> cachedIdentities;

  private String deviceName = "";
  private String deviceSwName = "";
  private String deviceId = "";
  private long appStartupMillis = 0;
  private int brandingId = 1;


  public UserEnvironmentInformation() {
    cachedRoles = new HashMap<Integer, Boolean>();
    cachedIdentities = new HashMap<Integer, Object>();
  }

  public UserEnvironmentInformation(String user, String id) {
    this();
    this.username = user;
    this.uid = new Integer(id);
  }

  @Override
  public long getAppStartupLocalMillis() {
    return appStartupMillis;
  }
  @Override
  public void setAppStartupLocalMillis(long value) {
    appStartupMillis = value;
  }

  public void setDevice(String devName, String devSwName, String devId) {
    deviceName = devName;
    deviceSwName = devSwName;
    deviceId = devId;
  }
  public String getDeviceName() {
    return deviceName;
  }
  public String getDeviceSwName() {
    return deviceSwName;
  }
  public String getDeviceId() {
    return deviceId;
  }
  public void adjustDeviceId(String newId) {
    deviceId = newId;
  }

  public void setLang(String val) {
    if (val == null) {
      throw new RuntimeException("Do not set Language to null");
    }
    if (!(val.startsWith("trans_"))) {
      throw new RuntimeException("Languages can be set to 'trans_<xxx>' only. You specified an illegal lang label: " + val);
    }


    try {
      lang = Integer.parseInt(val.substring(6));
      langAsString = val;
    } catch (Exception e) {
      throw new RuntimeException("Languages can be set to 'trans_<xxx>' only. You specified an illegal integer suffix: " + val);
    }
  }
  public int getLangIndex() {
    return lang;
  }
  public String getLang() {
    return langAsString;
  }

  @Deprecated
  public String getUserName_DEP() {
    return username;
  }
  public void setUserId(int u) {
    uid = u;
  }
  public int getUserId() {
    return uid;
  }
  public String getUserName() {
    return username;
  }
  public void setDynamicStatusInfo(String name) {
    dynamicStatusInfo = name;
  }
  public String getDynamicStatusInfo() {
    return dynamicStatusInfo;
  }
  public void setUserName(String u) {
    username = u;
  }
  public void setValue(String id, Boolean val) {
    cachedRoles.put(id.hashCode(), val);
  }
  public Boolean getValue(String id) {
    return cachedRoles.get(id.hashCode());
  }

  public void setIdentity(String id, Object val) {
    cachedIdentities.put(id.hashCode(), val);
  }
  public Object getIdentity(String id) {
    return cachedIdentities.get(id.hashCode());
  }


  public void setCompactMode() {
    appCompactMode = true;
  }
  public boolean isCompactMode() {
    return appCompactMode;
  }

  public void clearCachedValues(boolean includingIdentities) {
    cachedRoles = new HashMap<Integer, Boolean>();
    if (includingIdentities) {
      cachedIdentities = new HashMap<Integer, Object>();
    }
  }

  @Override
  public String toString() {
    return "" + username + " (" + uid + ") " + deviceName + " " + deviceId;
  }

  @Override
  public int getBrandingId() {
    return brandingId;
  }
  @Override
  public void setBrandingId(int id) {
    brandingId = id;
  }
  public void gcClean() {
    // cleanup done by jmx stack, not by userenv.
    // unregister etc.

    if (cachedRoles != null) {
      cachedRoles.clear();
      cachedRoles = null;

      cachedIdentities.clear();
      cachedIdentities = null;
    }
  }
}
