package org.modellwerkstatt.objectflow.runtime;

/*Generated by MPS */

import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;

public class Workarounds2 {

  public static List<IOFXProblem> limitProblemsTo(int count, List<IOFXProblem> allProblems) {
    // moware mini, limit problems to 10. Move this restriction to CMD container
    int origSize = ListSequence.fromList(allProblems).count();
    if (origSize > count) {
      allProblems = ListSequence.fromList(allProblems).page(0, count).toList();
      ListSequence.fromList(allProblems).addElement(new OFXProblem(false, "... and " + (origSize - count) + " more.", null, null));
    }
    return allProblems;
  }


  public static String[] getMainAndSubTitle(String all) {
    String[] result = new String[2];

    String[] splitted = all.split("\n");
    if (splitted.length == 1) {
      result[0] = stripEnd(all, " \n\r\t");
      result[1] = null;

    } else if (splitted.length == 2) {
      result[0] = splitted[0];
      result[1] = splitted[1];

    } else {
      result[0] = splitted[0];
      result[1] = all.substring(all.indexOf("\n") + 1);
    }


    return result;
  }

  private static String stripEnd(String str, String chars) {
    int end;
    if (str == null || (end = str.length()) == 0) {
      return str;
    }
    while ((0 != end) && (chars.indexOf(str.charAt(end - 1)) != -1)) {
      end--;
    }
    return str.substring(0, end);
  }

  public static void main(String[] args) {
    String[] res = getMainAndSubTitle("Hello World\n ");
    System.err.println("1 '" + res[0] + "'");
    System.err.println("2 '" + res[1] + "'");
  }
}
