package org.modellwerkstatt.objectflow.sdservices;

/*Generated by MPS */

import java.lang.reflect.Method;
import java.util.List;
import java.lang.reflect.InvocationTargetException;

public class CField {
  public String name;
  public OFXType type;
  public Class typeParameter;
  public Method setter;
  public Method getter;

  public CField(String n, OFXType t, Class tp) {
    name = n;
    type = t;
    typeParameter = tp;
  }

  public String info() {
    return "Field '" + name + "'";
  }

  public void init(Class parentClass) {
    try {
      String methodName1 = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
      getter = parentClass.getMethod(methodName1);

      if (this instanceof CListField) {
        String methodName2 = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
        setter = parentClass.getMethod(methodName2, List.class);

      } else {
        String methodName2 = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
        setter = parentClass.getMethod(methodName2, typeParameter);

      }

    } catch (NoSuchMethodException e) {
      throw new RuntimeException(info(), e);
    } catch (Exception e) {
      throw new RuntimeException(info(), e);
    }
  }

  public void set(Object root, Object value) {
    try {
      setter.invoke(root, value);
    } catch (InvocationTargetException e) {
      throw new RuntimeException(info(), e);
    } catch (IllegalAccessException e) {
      throw new RuntimeException(info(), e);
    } catch (Exception e) {
      throw new RuntimeException(info(), e);
    }
  }

  public Object get(Object root) {
    try {
      return getter.invoke(root);
    } catch (InvocationTargetException e) {
      throw new RuntimeException(info(), e);
    } catch (IllegalAccessException e) {
      throw new RuntimeException(info(), e);
    } catch (Exception e) {
      throw new RuntimeException(info(), e);
    }
  }


  @Override
  public String toString() {
    return type + " " + typeParameter.getSimpleName() + "." + name;
  }

  public String getTypeShortName() {
    return typeParameter.getSimpleName();
  }

  public enum OFXType {
    OFX_INT(),
    OFX_BIGDECIMAL(),
    OFX_STRING(),
    OFX_LOCALDATE(),
    OFX_DATETIME(),
    OFX_STATUS(),
    OFX_KEY_REFERENCE(),
    OFX_VALUE_OBJ(),
    OFX_LIST(),
    OFX_VP_BASE()
  }

}
