package org.modellwerkstatt.objectflow.sdservices;

/*Generated by MPS */

import java.util.List;
import java.util.ArrayList;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class CObjectField extends CField {
  public List<CField> fields = new ArrayList<CField>();
  private boolean isOriginalObject;
  private Constructor ctor;

  public CObjectField(String n, CField.OFXType t, Class cls) {
    super(n, t, cls);
    isOriginalObject = true;

    try {
      ctor = typeParameter.getDeclaredConstructor();
    } catch (NoSuchMethodException e) {
      throw new RuntimeException(info(), e);
    } catch (Exception e) {
      throw new RuntimeException(info(), e);
    }
  }

  public void addFieldAndInit(CField fld) {
    fld.init(typeParameter);
    fields.add(fld);
  }

  public void attachFieldsFromOrigObject(CObjectField origObject) {
    this.fields = origObject.fields;
    isOriginalObject = false;
  }

  public boolean isOrigNotAttached() {
    return isOriginalObject;
  }

  public <T> T newInstance() {
    try {
      return (T) ctor.newInstance();
    } catch (InstantiationException e) {
      throw new RuntimeException(info(), e);
    } catch (IllegalAccessException e) {
      throw new RuntimeException(info(), e);
    } catch (InvocationTargetException e) {
      throw new RuntimeException(info(), e);
    } catch (Exception e) {
      throw new RuntimeException(info(), e);
    }
  }

}
