package org.modellwerkstatt.objectflow.sdservices;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.serdes.IConvFormatOptions;
import org.modellwerkstatt.objectflow.serdes.SerdesException;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.joda.time.LocalDate;
import org.joda.time.DateTime;
import java.math.BigDecimal;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaStatus;

public abstract class JackyFieldSerdes<T> extends BaseSerdes<T> {
  protected JackyInfra infra;

  public JackyFieldSerdes(JackyInfra aInfra, Class<T> cls, IConvFormatOptions frmt) {
    super(cls, frmt);
    infra = aInfra;
  }

  protected VElement resolveJSonField(VObject jsonObj, CObjectField concept, String name) {

    name = formatters.fieldPathToJson(name);

    for (VElement jsonFld : jsonObj.fields) {
      if (jsonFld.name.equals(name)) {
        return jsonFld;
      }
    }

    if (formatters.hasMode(IConvFormatOptions.Mode.SET_MISSING_PROPERTIES_NULL)) {
      return null;
    }
    if (useCompactingArrays && jsonObj.fields.size() == 1) {
      return jsonObj.fields.get(0);
    }
    throw new SerdesException("Field " + concept.name + "." + name + " not found in json " + jsonObj);
  }

  protected void deserField(String fqPath, Object currentInstance, CField fieldMeta, VField fieldData) {
    Object objToSet = null;

    if (fieldMeta.type == CField.OFXType.OFX_STATUS) {
      objToSet = BaseSerdes.parseStatus(fieldMeta.typeParameter, (fieldData != null ? fieldData.value : null));

    } else if (fieldData != null) {
      objToSet = this.valueToObjectByType(fieldData.value, fieldMeta.type);

    } else if (fieldMeta.type == CField.OFXType.OFX_INT) {
      objToSet = Integer.valueOf(0);

    }

    fieldMeta.set(currentInstance, objToSet);
  }



  public static void serField(JsonGenerator gen, IConvFormatOptions frmtOpt, CField.OFXType type, String fldName, Object value, boolean compact) throws IOException {

    if (value == null) {
      if (!(compact)) {
        gen.writeFieldName(frmtOpt.fieldPathToJson(fldName));
      }
      gen.writeNull();

    } else {
      if (!(compact)) {
        gen.writeFieldName(frmtOpt.fieldPathToJson(fldName));
      }

      if (type == CField.OFXType.OFX_INT) {
        Integer integer = ((Integer) value);
        gen.writeNumber(integer);

      } else if (type == CField.OFXType.OFX_STRING) {
        String strng = ((String) value);
        gen.writeString(strng);

      } else if (type == CField.OFXType.OFX_LOCALDATE) {
        LocalDate ld = ((LocalDate) value);
        gen.writeString(frmtOpt.printLocalDate(ld));

      } else if (type == CField.OFXType.OFX_DATETIME) {
        DateTime dt = ((DateTime) value);
        gen.writeString(frmtOpt.printDateTime(dt));

      } else if (type == CField.OFXType.OFX_BIGDECIMAL) {
        BigDecimal bd = ((BigDecimal) value);
        if (frmtOpt.serializeBigDecimalAsString()) {
          gen.writeString(frmtOpt.printBigDecimal(bd));
        } else {
          gen.writeNumber(frmtOpt.printBigDecimal(bd));
        }
      } else if (type == CField.OFXType.OFX_STATUS) {
        IOFXMetaStatus.IOFXStatusElement elem = ((IOFXMetaStatus.IOFXStatusElement) value);
        String dbVal = elem.getDbValue();
        String dbValLower = dbVal.toLowerCase();
        boolean hasTwoElements = elem.getAllStatusElements().length == 2;

        // handle true / false dbValues on status automatically ..
        if (hasTwoElements && "true".equals(dbValLower)) {
          gen.writeBoolean(true);
        } else if (hasTwoElements && "false".equals(dbValLower)) {
          gen.writeBoolean(false);
        } else {
          gen.writeString(dbVal);
        }


      } else {
        throw new RuntimeException("This can not happen. Unknown type " + type);

      }
    }
  }

}
