package org.modellwerkstatt.objectflow.sdservices;

/*Generated by MPS */

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.StringWriter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;
import com.fasterxml.jackson.core.JsonParser;
import org.modellwerkstatt.objectflow.serdes.IConvFormatOptions;
import org.joda.time.LocalDate;
import org.joda.time.DateTime;
import java.math.BigDecimal;

public class JackyInfra {
  private JsonFactory factory;

  public JackyInfra() {
    factory = new JsonFactory();
  }

  public JsonGenerator createGenerator(StringWriter sw, boolean prettyPrint) {
    try {
      JsonGenerator gen = factory.createGenerator(sw);
      if (prettyPrint) {
        gen.setPrettyPrinter(new DefaultPrettyPrinter());
      }
      return gen;
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
  }
  public JsonParser createParser(String forString) {
    try {
      return factory.createParser(forString);
    } catch (IOException e) {
      throw new RuntimeException(e);
    }
  }


  public static Object identifyString(IConvFormatOptions formatters, String value) {
    // not json specific. move 
    try {
      LocalDate date = formatters.parseLocalDate(value);
      return date;
    } catch (Throwable t) {
    }

    try {
      DateTime dt = formatters.parseDateTime(value);
      return dt;
    } catch (Throwable t) {
    }

    try {
      BigDecimal deci = formatters.parseBigDecimal(value);
      return deci;
    } catch (Throwable t) {
    }

    return null;
  }

  public static VField.VType cTypeFromFQName(String typeFqName) {
    // not json specific, move

    if (typeFqName.contains("LocalDate")) {
      return VField.VType.LOCALDATE;

    } else if (typeFqName.contains("DateTime")) {
      return VField.VType.DATETIME;

    } else if (typeFqName.contains("BigDecimal")) {
      return VField.VType.BIGDECIMAL;

    }

    return VField.VType.STRING;
  }

  public static void debugObjectToString(StringBuilder result, String indent, VElement elem) {
    if (elem instanceof VObject) {
      VObject obj = ((VObject) elem);
      result.append(indent + obj + "\n");

      for (VElement it : obj.fields) {
        debugObjectToString(result, indent + "\t", it);
      }

    } else if (elem instanceof VList) {
      VList obj = ((VList) elem);
      result.append(indent + obj + " [\n");

      for (VElement it : obj.objects) {
        debugObjectToString(result, indent, it);
      }
      result.append(indent + "]\n");

    } else {
      VField fld = ((VField) elem);
      result.append(indent + elem + "\n");
    }
  }

  public static void printDebugObject(String indent, VElement elem) {

    if (elem instanceof VObject) {
      VObject obj = ((VObject) elem);
      System.err.println(indent + obj);

      for (VElement it : obj.fields) {
        printDebugObject(indent + "\t", it);
      }

    } else if (elem instanceof VList) {
      VList obj = ((VList) elem);
      System.err.println(indent + obj + " [");
      for (VElement it : obj.objects) {
        printDebugObject(indent, it);
      }

      System.err.println(indent + "]");

    } else {
      VField fld = ((VField) elem);
      System.err.println(indent + elem);
    }
  }

  public static void printDebugObject(String indent, CField elem) {

    if (elem instanceof CObjectField) {
      CObjectField obj = ((CObjectField) elem);
      System.err.println(indent + obj + ((obj.isOrigNotAttached() ? "" : " (not orig)")));

      if (obj.isOrigNotAttached()) {
        for (CField it : obj.fields) {
          printDebugObject(indent + "\t", it);
        }
      }

    } else if (elem instanceof CListField) {
      CListField obj = ((CListField) elem);
      System.err.println(indent + obj + ((obj.isOrigNotAttached() ? "" : " (not orig)")) + " [");
      if (obj.isOrigNotAttached()) {
        for (CField it : obj.fields) {
          printDebugObject(indent, it);
        }
      }

      System.err.println(indent + "]");

    } else {
      System.err.println(indent + elem);
    }
  }

  public static void main(String[] args) {
    JackyInfra helper = new JackyInfra();


    try {
      StringWriter sw = new StringWriter();
      JsonGenerator gen = helper.createGenerator(sw, true);

      gen.writeStartObject();

      gen.writeFieldName("test");
      gen.writeNumber(1.0f);

      gen.writeEndObject();
      gen.close();

      System.err.println("> " + sw.toString() + "<");

    } catch (Exception e) {
      e.printStackTrace();
    }




  }

}
