package org.modellwerkstatt.objectflow.sdservices;

/*Generated by MPS */

import com.fasterxml.jackson.core.JsonParser;
import org.modellwerkstatt.objectflow.serdes.SerdesException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import com.fasterxml.jackson.core.JsonParseException;

public class JackyParsed {
  private JsonParser p;
  private long tokenCnt;


  private VParent root;
  private VParent current;


  public JackyParsed() {
    tokenCnt = 0;
  }

  public void error(String desc) {
    throw new SerdesException("Token num " + tokenCnt + " [" + p.getCurrentToken() + "] " + ": " + desc);
  }
  public void l(String s) {
  }


  public void processToken(JsonToken token) throws IOException {
    l(String.format("ConvJacksonParser.parse(): %20s %20s %20s", token, p.getCurrentName(), p.getValueAsString()));

    if (token == null) {
      error("processToken() can not process null token.");
    }

    switch (token) {
      case START_OBJECT:
        VObject newObject = new VObject(current, p.getCurrentName());
        current = newObject;
        break;

      case END_OBJECT:
        if (current.isList()) {
          error("This can not happen, we are no longer working on an objet item here. current is " + current);
        }

        VParent parent = current.parent;
        if (parent != null) {
          if (parent.isList()) {
            parent.addObjectToList(current);
          } else {
            parent.addField(current);
          }
        }

        current = parent;
        break;

      case START_ARRAY:
        String listName = p.getCurrentName();
        if (listName == null) {
          listName = "listContent";
        }

        VList newList = new VList(current, listName);
        current = newList;
        break;

      case END_ARRAY:
        // add the open list as field and close ist
        if (!(current.isList())) {
          error("This can not happen, we are no longer working on a list item here. current is " + current);
        }

        parent = current.parent;
        if (parent != null) {
          parent.addField(current);
        }
        current = parent;

        break;

      case VALUE_EMBEDDED_OBJECT:
        current.addField(new VField(p.currentName(), p.getValueAsString(), VField.VType.OBJECT));

        break;

      case VALUE_NULL:
        current.addField(new VField(p.currentName(), p.getValueAsString(), VField.VType.NULL));
        break;

      case VALUE_NUMBER_FLOAT:
        current.addField(new VField(p.currentName(), p.getValueAsString(), VField.VType.BIGDECIMAL));
        break;

      case VALUE_NUMBER_INT:
        current.addField(new VField(p.currentName(), p.getValueAsString(), VField.VType.INT));
        break;

      case VALUE_STRING:
        current.addField(new VField(p.currentName(), p.getValueAsString(), VField.VType.STRING));
        break;

      case VALUE_FALSE:
      case VALUE_TRUE:
        current.addField(new VField(p.currentName(), p.getValueAsString(), VField.VType.BOOLEAN));
        break;
      default:
        // ignored
    }
    tokenCnt++;
  }

  public VParent parse(JsonParser parser) {
    l("\n\n\n\n ---------------------------- PARSE ------------------------------");

    try {
      p = parser;

      JsonToken token = p.nextToken();

      if (token.equals(JsonToken.START_ARRAY)) {
        root = current = new VList(null, "ROOTLIST");
      } else if (token.equals(JsonToken.START_OBJECT)) {
        root = current = new VObject(null, "ROOT");
      } else {
        error("The JackyParser needs a json string start with Array or Object, but it is " + token);
      }

      token = p.nextToken();
      while (!(p.isClosed()) && token != null) {
        processToken(token);
        token = p.nextToken();
      }

      if (current != null) {
        error("The Json tree was not closed completle. We are at object " + current + " now.");
      }
      // okay. process this now. 

      return root;

    } catch (JsonParseException e) {
      String desc = (current != null ? "last successfully parsed was '" + current + "'" : "problems within first element.");
      throw new SerdesException("Can not parse json content - " + desc);

    } catch (IOException e) {
      throw new RuntimeException(e);
    } finally {

      try {
        if (p != null) {
          p.close();
        }
      } catch (IOException e) {
      }

      l("ConvJacksonParser.parse() DONE; processer " + tokenCnt + " tokens.");
    }
  }


}
