package org.modellwerkstatt.objectflow.sdservices;

/*Generated by MPS */

import org.joda.time.format.DateTimeFormatter;
import org.modellwerkstatt.objectflow.runtime.MoWareFormattersFactory;
import org.modellwerkstatt.objectflow.runtime.OFXStringFormatter2;
import org.modellwerkstatt.objectflow.runtime.OFXInteger;
import org.modellwerkstatt.objectflow.runtime.OFXStatus;
import org.modellwerkstatt.objectflow.runtime.OFXString;
import org.modellwerkstatt.objectflow.runtime.OFXBigDecimal;
import org.modellwerkstatt.objectflow.runtime.OFXLocalDate;
import org.modellwerkstatt.objectflow.runtime.OFXDateTime;
import org.modellwerkstatt.objectflow.runtime.OFXKeyReference;
import org.modellwerkstatt.objectflow.runtime.OFXValueObject;
import org.modellwerkstatt.objectflow.runtime.OFXList;
import org.modellwerkstatt.objectflow.runtime.OFXVPBase;

public class LgcyFopGraphPrinter implements ILgcyGraphPrinter {
  private static final String INDENT = "   ";
  public static DateTimeFormatter xfoDateOnlyFormatter = MoWareFormattersFactory.forDateTimePattern("EEE dd.MM.yyyy", OFXStringFormatter2.DEFAULT_LOCALE);
  public static DateTimeFormatter xfoDesignerFormatterTime = MoWareFormattersFactory.forDateTimePattern("yyyy'-'MM'-'dd'T'HH':'mm':'ss", OFXStringFormatter2.DEFAULT_LOCALE);
  public static DateTimeFormatter xfoDesignerFormatterDate = MoWareFormattersFactory.forDateTimePattern("yyyy'-'MM'-'dd", OFXStringFormatter2.DEFAULT_LOCALE);


  private LgcyGraphIntrospector introspector;
  private StringBuilder sb = new StringBuilder();
  private Object rootObject;

  public LgcyFopGraphPrinter(Object rootObj) {
    introspector = new LgcyGraphIntrospector();
    this.rootObject = rootObj;
  }

  public String escapeXml(String someText) {
    if (someText != null) {
      return someText.replace("&", "&amp;").replace(">", "&gt;").replace("<", "&lt;").replace("'", "&apos;").replace("\"", "&quot;");
    }
    return someText;
  }


  public void handleIntro(String indent, String objectName, String simpleFields) {
  }

  public void handleInteger(String indent, String fieldname, OFXInteger value, boolean isKey) {
    sb.append(indent + "<" + fieldname.toUpperCase() + ">" + value.getValue() + "</" + fieldname.toUpperCase() + ">\n");
  }
  public void handleStatus(String indent, String fieldname, OFXStatus ofxStatus, boolean isKey) {
    String dbValue = "(null)";
    if (ofxStatus.getValue() != null) {
      dbValue = ofxStatus.getValue().getDbValue();
    }
    sb.append(indent + "<" + fieldname.toUpperCase() + "  " + fieldname + " = \"" + dbValue + "\">" + dbValue + "</" + fieldname.toUpperCase() + ">\n");
  }
  public void handleString(String indent, String fieldname, OFXString value, boolean isKey) {
    sb.append(indent + "<" + fieldname.toUpperCase() + ">" + escapeXml(value.getValue()) + "</" + fieldname.toUpperCase() + ">\n");
  }


  public void handleBigDecimal(String indent, String fieldname, OFXBigDecimal value, boolean isKey) {
    sb.append(indent + "<" + fieldname.toUpperCase() + "  " + fieldname + " = \"" + value.getValue() + "\">" + value.getValue() + "</" + fieldname.toUpperCase() + ">\n");
  }

  public void handleLocalDate(String indent, String fieldname, OFXLocalDate value) {
    if (value.getValue() == null) {
      sb.append(indent + "<" + fieldname.toUpperCase() + "  " + fieldname + " = \"\"> </" + fieldname.toUpperCase() + ">\n");
    } else {
      sb.append(indent + "<" + fieldname.toUpperCase() + "  " + fieldname + " = \"" + xfoDesignerFormatterDate.print(value.getValue()) + "\">" + xfoDateOnlyFormatter.print(value.getValue()) + "</" + fieldname.toUpperCase() + ">\n");
    }
  }
  public void handleDateTime(String indent, String fieldname, OFXDateTime value) {
    if (value.getValue() == null) {
      sb.append(indent + "<" + fieldname.toUpperCase() + "  " + fieldname + " = \"\"> </" + fieldname.toUpperCase() + ">\n");
    } else {
      sb.append(indent + "<" + fieldname.toUpperCase() + "  " + fieldname + " = \"" + xfoDesignerFormatterTime.print(value.getValue()) + "\">" + xfoDateOnlyFormatter.print(value.getValue()) + "</" + fieldname.toUpperCase() + ">\n");
    }
  }




  public void handleKefReference(String indent, String fieldname, OFXKeyReference value) {
    if (!(value.getOpposite()) && value.isInitialized()) {
      sb.append(indent + "<" + fieldname.toUpperCase() + ">\n");
      introspector.introspectionPrint(indent + INDENT, value.getValue(), this);
      sb.append(indent + "</" + fieldname.toUpperCase() + ">\n");
    }

  }
  public void handleValueObject(String indent, String fieldname, OFXValueObject value, boolean isKey) {
    sb.append(indent + "<" + fieldname.toUpperCase() + ">\n");
    // introspect value object
    introspector.introspectionPrint(indent + INDENT, value.getValue(), this);
    sb.append(indent + "</" + fieldname.toUpperCase() + ">\n");

  }
  public void handleList(String indent, String fieldname, OFXList value) {
    int i = 0;
    sb.append("<" + fieldname.toUpperCase() + "SET>\n");
    for (Object obj : value.getValue()) {
      sb.append("<" + fieldname.toUpperCase() + " num=\"" + i++ + "\">\n");
      introspector.introspectionPrint(indent + INDENT, obj, this);
      sb.append("</" + fieldname.toUpperCase() + ">");
    }
    sb.append("</" + fieldname.toUpperCase() + "SET>\n");
  }
  public void handleVirtualProperty(String indent, String fieldname, OFXVPBase metaInfo, Object value, boolean isKey) {
    if (value instanceof String) {
      value = escapeXml(((String) value));
    }
    sb.append(indent + "<" + fieldname.toUpperCase() + ">" + value + "</" + fieldname.toUpperCase() + ">\n");
  }

  public void handleOutro() {
  }
  public String printGraph() {
    introspector.introspectionPrint("", this.rootObject, this);
    return sb.toString();
  }
}
