package org.modellwerkstatt.objectflow.sdservices;

/*Generated by MPS */

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import org.modellwerkstatt.objectflow.runtime.OFXInteger;
import org.modellwerkstatt.objectflow.runtime.OFXBigDecimal;
import java.math.BigDecimal;
import org.modellwerkstatt.objectflow.runtime.OFXString;
import org.modellwerkstatt.objectflow.runtime.OFXLocalDate;
import org.joda.time.LocalDate;
import org.modellwerkstatt.objectflow.runtime.OFXDateTime;
import org.joda.time.DateTime;
import org.modellwerkstatt.objectflow.runtime.OFXStatus;
import java.lang.reflect.ParameterizedType;
import org.modellwerkstatt.objectflow.runtime.OFXValueObject;
import org.modellwerkstatt.objectflow.runtime.OFXKeyReference;
import org.modellwerkstatt.objectflow.runtime.OPPOSITE;
import org.modellwerkstatt.objectflow.runtime.OFXList;
import org.modellwerkstatt.objectflow.runtime.OFXVPBase;
import java.lang.reflect.InvocationTargetException;

public class MoWareEntityReflector {
  private Method theListAdderMethodOfListClass;
  private HashMap<String, CObjectField> createdObjectFields = new HashMap<String, CObjectField>();

  public MoWareEntityReflector() {
    try {
      String methodName1 = "add";

      Class listClass = List.class;
      theListAdderMethodOfListClass = listClass.getMethod(methodName1, Object.class);


    } catch (SecurityException e) {
      throw new RuntimeException(e);
    } catch (IllegalArgumentException e) {
      throw new RuntimeException(e);
    } catch (NoSuchMethodException e) {
      throw new RuntimeException(e);
    }
  }


  public void constructCObjectTree(CObjectField root) {
    try {
      for (Field field : root.typeParameter.getDeclaredFields()) {
        field.setAccessible(true);
        addFieldIfRelevant(root, field);
      }

      Class superCls = root.typeParameter.getSuperclass();
      while (superCls != null) {

        for (Field field : superCls.getDeclaredFields()) {
          field.setAccessible(true);
          addFieldIfRelevant(root, field);
        }
        superCls = superCls.getSuperclass();
      }


    } catch (IllegalArgumentException e) {
      throw new RuntimeException(e);

    } catch (SecurityException e) {
      throw new RuntimeException(e);

    } catch (ClassNotFoundException e) {
      throw new RuntimeException(e);
    }

  }


  private void addFieldIfRelevant(CObjectField root, Field field) throws ClassNotFoundException {

    CField cFld = getCTypeWhenOFXRelatedOrNull(root, field);

    if (cFld != null) {
      if (cFld instanceof CObjectField) {
        CObjectField objField = ((CObjectField) cFld);
        if (objField.isOrigNotAttached()) {
          constructCObjectTree(objField);
        }

      } else if (cFld instanceof CListField) {
        CListField listFld = ((CListField) cFld);
        if (listFld.isOrigNotAttached()) {
          constructCObjectTree(listFld);
        }

      }

      root.addFieldAndInit(cFld);
    }
  }

  /**
   * There could be cycles like InvoicePos contains a list of InvoicePos
   * we ll check here on <root object type> and fieldName (ofxtype, typeParam just double checked)
   */
  public CObjectField createNewCObjectOrNull(String fieldName, CField.OFXType ofxtype, Class typeParam) {


    CObjectField field;
    if (ofxtype.equals(CField.OFXType.OFX_KEY_REFERENCE)) {
      field = new CObjectField(fieldName, CField.OFXType.OFX_KEY_REFERENCE, typeParam);

    } else if (ofxtype.equals(CField.OFXType.OFX_LIST)) {
      field = new CListField(fieldName, CField.OFXType.OFX_LIST, typeParam);

    } else if (ofxtype.equals(CField.OFXType.OFX_VALUE_OBJ)) {
      field = new CObjectField(fieldName, CField.OFXType.OFX_VALUE_OBJ, typeParam);

    } else {
      throw new RuntimeException("This can not happen. We do not support " + ofxtype);
    }


    String key = typeParam.getName();
    CObjectField existing = createdObjectFields.get(key);

    // do we have a (partial) construction of this objecT?
    if (existing != null) {
      field.attachFieldsFromOrigObject(existing);

    } else {
      // create it. 
      createdObjectFields.put(key, field);
    }

    return field;
  }

  private CField getCTypeWhenOFXRelatedOrNull(CObjectField rootOfField, Field f) throws ClassNotFoundException {
    Class cls = f.getType();
    Type type = f.getGenericType();
    String name = f.getName();



    if (cls == OFXInteger.class) {
      return new CField(name, CField.OFXType.OFX_INT, int.class);

    } else if (cls == OFXBigDecimal.class) {
      return new CField(name, CField.OFXType.OFX_BIGDECIMAL, BigDecimal.class);

    } else if (cls == OFXString.class) {
      return new CField(name, CField.OFXType.OFX_STRING, String.class);

    } else if (cls == OFXLocalDate.class) {
      return new CField(name, CField.OFXType.OFX_LOCALDATE, LocalDate.class);

    } else if (cls == OFXDateTime.class) {
      return new CField(name, CField.OFXType.OFX_DATETIME, DateTime.class);

    } else if (cls == OFXStatus.class) {
      ParameterizedType pt = ((ParameterizedType) type);
      Class typeParam = Class.forName(pt.getActualTypeArguments()[0].getTypeName());
      return new CField(name, CField.OFXType.OFX_STATUS, typeParam);

    } else if (cls == OFXValueObject.class) {
      ParameterizedType pt = ((ParameterizedType) type);
      Class typeParam = Class.forName(pt.getActualTypeArguments()[0].getTypeName());
      return createNewCObjectOrNull(name, CField.OFXType.OFX_VALUE_OBJ, typeParam);

    } else if (cls == OFXKeyReference.class) {
      if (f.getAnnotation(OPPOSITE.class) == null) {
        ParameterizedType pt = ((ParameterizedType) type);
        Class typeParam = Class.forName(pt.getActualTypeArguments()[1].getTypeName());
        return createNewCObjectOrNull(name, CField.OFXType.OFX_KEY_REFERENCE, typeParam);

      } else {
        // TODO: just the key : ) hacked
        ParameterizedType pt = ((ParameterizedType) type);
        Class typeParam = Class.forName(pt.getActualTypeArguments()[0].getTypeName());
        name += "KEY";

        if (typeParam == Integer.class) {
          return new CField(name, CField.OFXType.OFX_INT, Integer.class);
        } else if (typeParam == String.class) {
          return new CField(name, CField.OFXType.OFX_STRING, String.class);
        } else {
          return createNewCObjectOrNull(name, CField.OFXType.OFX_VALUE_OBJ, typeParam);
        }
      }

    } else if (cls == OFXList.class) {
      ParameterizedType pt = ((ParameterizedType) type);
      Class typeParam = Class.forName(pt.getActualTypeArguments()[0].getTypeName());
      return createNewCObjectOrNull(name, CField.OFXType.OFX_LIST, typeParam);

    } else if (cls == OFXVPBase.class) {
      throw new RuntimeException("VirtualProps are not supported for serdes yet.");

    } else {
      // others like int (e.g. tcn) or bool do not get serialized... 

    }

    return null;
  }

  public void callListAdder(Object list, Object arg) {
    try {
      theListAdderMethodOfListClass.invoke(list, arg);

    } catch (SecurityException e) {
      throw new RuntimeException(e);
    } catch (IllegalArgumentException e) {
      throw new RuntimeException(e);
    } catch (IllegalAccessException e) {
      throw new RuntimeException(e);
    } catch (InvocationTargetException e) {
      throw new RuntimeException(e);
    }
  }

  public static Object statusFromString(Class statusClass, String value) {
    try {
      String methodName = "fromString";
      Method method;

      method = statusClass.getMethod(methodName, String.class);
      return method.invoke(null, value);

    } catch (SecurityException e) {
      throw new RuntimeException(e);
    } catch (IllegalArgumentException e) {
      throw new RuntimeException(e);
    } catch (NoSuchMethodException e) {
      throw new RuntimeException(e);
    } catch (IllegalAccessException e) {
      throw new RuntimeException(e);
    } catch (InvocationTargetException e) {
      throw new RuntimeException(e);
    }
  }


}
