package org.modellwerkstatt.objectflow.sdservices;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.serdes.IConvFormatOptions;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.Element;
import java.util.ArrayList;
import org.modellwerkstatt.objectflow.serdes.SerdesException;
import org.w3c.dom.Document;
import org.joda.time.LocalDate;
import org.joda.time.DateTime;
import java.math.BigDecimal;
import org.modellwerkstatt.objectflow.runtime.IOFXMetaStatus;

/**
 * Check https://mkyong.com/java/how-to-create-xml-file-in-java-dom/
 * for some infos 
 * 
 * 
 * 
 */
public abstract class XmlFieldSerdes<T> extends BaseSerdes<T> {

  public XmlFieldSerdes(Class<T> cls, IConvFormatOptions frmt) {
    super(cls, frmt);
  }

  protected List filterOnElements(Node node) {
    List<Element> elementNodes = new ArrayList<Element>();
    for (int i = 0; i < node.getChildNodes().getLength(); i++) {
      Node cld = node.getChildNodes().item(i);
      if (cld.getNodeType() == Node.ELEMENT_NODE) {
        elementNodes.add(((Element) cld));
      }
    }
    return elementNodes;
  }

  protected Node resolveXMLField(List<Node> nodes, CObjectField concept, String name) {

    name = formatters.fieldPathToJson(name);

    for (int i = 0; i < nodes.size(); i++) {
      Node nd = nodes.get(i);
      if (name.equals(nd.getNodeName())) {
        return nd;
      }
    }

    // ignore case 
    for (int i = 0; i < nodes.size(); i++) {
      Node nd = nodes.get(i);
      if (name.toLowerCase().equals(nd.getNodeName().toLowerCase())) {
        return nd;
      }
    }


    if (formatters.hasMode(IConvFormatOptions.Mode.SET_MISSING_PROPERTIES_NULL)) {
      return null;
    }
    if (useCompactingArrays && nodes.size() == 1) {
      return nodes.get(0);
    }
    throw new SerdesException("DTO Field " + concept.name + "." + name + " not found in xml " + nodes);
  }

  protected boolean needsCdata(String st) {
    return st.matches(".*[&<>].*");
  }

  protected void deserField(String fqPath, Object currentInstance, CField fld, Document xmlRootDoc, Node parentElement, Node domElement) {
    Object objToSet = null;

    if (fld.type == CField.OFXType.OFX_STATUS) {
      objToSet = MoWareEntityReflector.statusFromString(fld.typeParameter, (domElement != null ? domElement.getTextContent() : null));

    } else if (domElement != null) {
      String nodeTextContent = domElement.getTextContent();
      // CDATA is handled automatically
      objToSet = this.valueToObjectByType(nodeTextContent, fld.type);

    }

    fld.set(currentInstance, objToSet);
  }

  protected Element serField(Document rootDocument, String fqPath, CField fld, Object value, boolean compactArray) {

    if (value == null) {
      Element nullElement = rootDocument.createElement(formatters.fieldPathToJson(fld.name));
      // no content
      return nullElement;

    } else {
      Element elem = rootDocument.createElement(formatters.fieldPathToJson(fld.name));

      if (fld.type == CField.OFXType.OFX_INT) {
        Integer integer = ((Integer) value);
        elem.setTextContent("" + integer);

      } else if (fld.type == CField.OFXType.OFX_STRING) {
        String strng = ((String) value);
        if (needsCdata(strng)) {
          elem.appendChild(rootDocument.createCDATASection(strng));
        } else {
          elem.setTextContent("" + strng);
        }

      } else if (fld.type == CField.OFXType.OFX_LOCALDATE) {
        LocalDate ld = ((LocalDate) value);
        elem.setTextContent(formatters.printLocalDate(ld));

      } else if (fld.type == CField.OFXType.OFX_DATETIME) {
        DateTime dt = ((DateTime) value);
        elem.setTextContent(formatters.printDateTime(dt));

      } else if (fld.type == CField.OFXType.OFX_BIGDECIMAL) {
        BigDecimal bd = ((BigDecimal) value);
        if (formatters.serializeBigDecimalAsString()) {
          elem.setTextContent(formatters.printBigDecimal(bd));
        } else {
          // no difference in xml ?
          elem.setTextContent(formatters.printBigDecimal(bd));
        }
      } else if (fld.type == CField.OFXType.OFX_STATUS) {
        IOFXMetaStatus.IOFXStatusElement statusElem = ((IOFXMetaStatus.IOFXStatusElement) value);
        String dbVal = statusElem.getDbValue();
        String dbValLower = dbVal.toLowerCase();
        boolean hasTwoElements = statusElem.getAllStatusElements().length == 2;

        // handle true / false dbValues on status automatically - ? no diff in xml ? 
        if (hasTwoElements && "true".equals(dbValLower)) {
          elem.setTextContent("true");
        } else if (hasTwoElements && "false".equals(dbValLower)) {
          elem.setTextContent("false");
        } else {
          elem.setTextContent(dbVal);
        }

      } else {
        throw new RuntimeException("This can not happen. Unknown type " + fld.type);

      }
      return elem;
    }
  }
}
