package org.modellwerkstatt.objectflow.serdes;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.sdservices.JackyGraphSerdes;
import org.modellwerkstatt.objectflow.sdservices.XmlGraphSerdes;
import org.modellwerkstatt.objectflow.sdservices.FopXmlSer;
import org.modellwerkstatt.objectflow.sdservices.StringSer;

/**
 * CONV serdes conversion interface
 * 
 * you can have multiple instances of configured serialize/deserializers in an application.
 * therefore this conv is not handled via ioc container. right now, there are also no other 
 * CONV's available.
 * 
 * technical exceptions, security, introspection etc. result in RuntimeException
 * missing fields, too may, generally wrong json results in SerdesException
 * 
 */
public class CONV {
  public static final IConvFormatOptions CONV_DEFAULT_EN = new ConvStdFormatters(new ConvFormatOptions("hh:mm:ss dd.MM.yy", "dd.MM.yy", "#0.00", "en", IConvFormatOptions.Mode.ALL_PROPERTIES_NECESSARY));

  public static <T> IConvSerdes<T> jsonSerDes(Class<T> type, IConvFormatOptions config) {
    return new JackyGraphSerdes<T>(type, config);
  }
  public static <T> IConvSerdes<T> xmlSerDes(Class<T> type, IConvFormatOptions config) {
    return new XmlGraphSerdes<T>(type, config);
  }
  public static IConvSerdes<Object> fopXmlSer() {
    return new FopXmlSer<Object>();
  }
  public static <T> IConvSerdes<T> stringSer(Class<T> type, IConvFormatOptions config) {
    return new StringSer<T>(type, config);
  }

}
