package org.modellwerkstatt.objectflow.serdes;

/*Generated by MPS */

import org.joda.time.format.DateTimeFormatter;
import java.text.DecimalFormat;
import java.util.HashMap;
import org.modellwerkstatt.objectflow.runtime.MoWareFormattersFactory;
import org.joda.time.LocalDate;
import org.joda.time.DateTime;
import java.math.BigDecimal;
import java.text.ParseException;

public class ConvStdFormatters implements IConvFormatOptions {
  protected ConvFormatOptions options;
  protected DateTimeFormatter dateTimeFormatter;
  protected DateTimeFormatter localDateFormatter;
  protected DecimalFormat decimalFormat;
  protected HashMap<String, String> jsonKeyToField;
  protected HashMap<String, String> fieldKeyToJson;
  protected boolean serializeBigDeciAsString = false;


  public ConvStdFormatters(ConvFormatOptions opt) {
    init(opt);
  }

  public ConvStdFormatters(ConvFormatOptions opt, HashMap<String, String> jToF) {
    jsonKeyToField = jToF;
    init(opt);
  }

  public void init(ConvFormatOptions opts) {
    options = opts;
    dateTimeFormatter = MoWareFormattersFactory.forDateTimePattern(options.dateTimeFormat, options.locale);
    localDateFormatter = MoWareFormattersFactory.forDateTimePattern(options.localDateFormat, options.locale);
    decimalFormat = MoWareFormattersFactory.forDecimalFormatPattern(options.bigDeciFormat, options.locale);

    if (options.bigDeciFormat.contains(",")) {
      serializeBigDeciAsString = true;
    }

    if (jsonKeyToField != null) {
      fieldKeyToJson = new HashMap<String, String>();
      for (String key : jsonKeyToField.keySet()) {
        String value = jsonKeyToField.get(key);
        fieldKeyToJson.put(value, key);
      }

    }

  }

  @Override
  public LocalDate parseLocalDate(String dateSt) {
    return localDateFormatter.parseLocalDate(dateSt);
  }
  @Override
  public String printLocalDate(LocalDate date) {
    return localDateFormatter.print(date);
  }
  @Override
  public DateTime parseDateTime(String dtSt) {
    return dateTimeFormatter.parseDateTime(dtSt);
  }
  @Override
  public String printDateTime(DateTime dt) {
    return dateTimeFormatter.print(dt);
  }
  @Override
  public BigDecimal parseBigDecimal(String bdSt) {
    try {
      return ((BigDecimal) decimalFormat.parse(bdSt));
    } catch (ParseException e) {
      throw new SerdesException("Can not convert '" + bdSt + "' to a decimal.", e);
    }
  }
  @Override
  public String printBigDecimal(BigDecimal bd) {
    return decimalFormat.format(bd);
  }

  @Override
  public boolean serializeBigDecimalAsString() {
    return serializeBigDeciAsString;
  }

  @Override
  public String jsonPathToField(String jsonName) {
    if (jsonKeyToField == null) {
      return jsonName;
    }
    if (jsonKeyToField.containsKey(jsonName)) {
      return jsonKeyToField.get(jsonName);
    }
    return jsonName;
  }

  @Override
  public String fieldPathToJson(String propName) {
    if (fieldKeyToJson == null) {
      return propName;
    }
    if (fieldKeyToJson.containsKey(propName)) {
      return fieldKeyToJson.get(propName);
    }
    return propName;
  }


  @Override
  public boolean hasMode(IConvFormatOptions.Mode mode) {
    for (IConvFormatOptions.Mode m : options.modes) {
      if (mode.equals(m)) {
        return true;
      }
    }
    return false;
  }
}
