package org.modellwerkstatt.objectflow.serdes;

/*Generated by MPS */

import org.joda.time.LocalDate;
import org.joda.time.DateTime;
import java.math.BigDecimal;

/**
 *   Serialization / Deserialization of DTOs
 * 
 * DTO and the graph are always kind of master, i.e. the properties in the DTO are
 * the single source of truth. This leads to different options now.  
 * 
 * - ALL_PROPERTIES_NECESSARY: all props have to be present in json
 * - SET_MISSING_PROPERTIES_NULL:  props might be missing in json. fill them with null
 * 
 * However, the json might always contain props, that are not present in the DTO
 * 
 */
public interface IConvFormatOptions {

  LocalDate parseLocalDate(String dateSt);
  String printLocalDate(LocalDate date);

  DateTime parseDateTime(String dtSt);
  String printDateTime(DateTime dt);

  BigDecimal parseBigDecimal(String bdSt);
  String printBigDecimal(BigDecimal bd);
  boolean serializeBigDecimalAsString();

  String jsonPathToField(String jsonName);
  String fieldPathToJson(String propName);

  boolean hasMode(Mode mode);
  enum Mode {
    ALL_PROPERTIES_NECESSARY(),
    SET_MISSING_PROPERTIES_NULL(),
    SIMPLE_ARRAYS_TO_DTO(),
    NULL_ARRAY_TO_EMPTY(),
    DEBUG_TO_STDERR(),
    PRETTY()
  }

}
