package org.modellwerkstatt.objectflow.services;

/*Generated by MPS */

import javax.naming.ldap.LdapContext;
import javax.naming.NamingException;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import javax.naming.directory.SearchControls;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import javax.naming.directory.Attribute;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.ldap.InitialLdapContext;

public class LdapAccess {
  public static final String DEFAULT_INITIAL_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
  public static final String DEFAULT_SECURITY_AUTHENTICATION = "Simple";

  private String ldapServerAddress;
  private boolean useSsl;


  public LdapAccess(String srv, boolean ssl) {
    ldapServerAddress = srv;
    useSsl = ssl;

    // Idea: We could easily speed up things by having LdapAccess having a state with the 
    // ldapContext, then using the LdapAccess to create a connection, hold connection, do searches
    // and let client close state afterwards with a finally
    // 
    // 
  }

  public boolean loginPossible(Search srch) {
    LdapContext userContext = null;
    boolean usernameOk = false;
    try {
      userContext = createContextToUserPwd(srch.principal, srch.principalPwd);
      usernameOk = true;

    } catch (NamingException ex) {
      // no, can not log in ..

    } finally {
      closeIfNotNull(userContext);
    }
    return usernameOk;
  }

  public List<String> ldapSingleEntrySearch(Search srch) {
    LdapContext bindContext = null;
    List<String> results = ListSequence.fromList(new ArrayList<String>());

    try {
      bindContext = createContextToUserPwd(srch.principal, srch.principalPwd);

      SearchControls constraints = new SearchControls();
      constraints.setSearchScope(SearchControls.SUBTREE_SCOPE);
      String[] attrIDs = {srch.returnAttr};
      constraints.setReturningAttributes(attrIDs);

      NamingEnumeration answer = bindContext.search(srch.searchBase, srch.queryString, constraints);

      if (answer.hasMore()) {
        Attributes attrs = ((SearchResult) answer.next()).getAttributes();

        Attribute returningAttr = attrs.get(srch.returnAttr);
        if (returningAttr != null) {
          for (Enumeration e1 = returningAttr.getAll(); e1.hasMoreElements();) {
            ListSequence.fromList(results).addElement(e1.nextElement().toString());
          }
        }
      }

      if (answer.hasMore()) {
        throw new RuntimeException("More then one entry for query '" + srch.queryString + "' retrieved, contact directory admin.");
      }

    } catch (NamingException nex) {
      throw new RuntimeException("Ldap Bind: Connection failed", nex);

    } finally {
      closeIfNotNull(bindContext);
    }

    return results;
  }



  protected void closeIfNotNull(LdapContext context) {
    if (context != null) {
      try {
        context.close();
      } catch (NamingException ex) {
        throw new RuntimeException("LdapContext : Error while closing context", ex);
      }
    }
  }


  protected LdapContext createContextToUserPwd(String principal, String pwd) throws NamingException {
    Hashtable<String, String> userEnv = new Hashtable<String, String>();

    userEnv.put(Context.INITIAL_CONTEXT_FACTORY, DEFAULT_INITIAL_CONTEXT_FACTORY);
    userEnv.put(Context.SECURITY_AUTHENTICATION, DEFAULT_SECURITY_AUTHENTICATION);
    userEnv.put(Context.SECURITY_PRINCIPAL, principal);
    userEnv.put(Context.SECURITY_CREDENTIALS, pwd);
    userEnv.put(Context.PROVIDER_URL, ldapServerAddress);
    if (useSsl) {
      userEnv.put(Context.SECURITY_PROTOCOL, "ssl");
    }

    return new InitialLdapContext(userEnv, null);
  }

  public static class Search {
    private String principal;
    private String principalPwd;

    private String returnAttr;

    private String searchBase;
    private String queryString;

    public Search clone() {
      Search clone = new Search(principal, principalPwd);
      clone.returnAttr = this.returnAttr;
      clone.searchBase = this.searchBase;
      clone.queryString = this.queryString;
      return clone;
    }

    public Search(String aPrincipal, String aPrincipalPwd) {
      principal = aPrincipal;
      principalPwd = aPrincipalPwd;
    }

    public Search withPassword(String pwd) {
      Search cl = clone();
      cl.principalPwd = pwd;
      return cl;
    }

    public Search withReturnAttr(String attr) {
      Search cl = clone();
      cl.returnAttr = attr;
      return cl;
    }

    public Search withBase(String base) {
      Search cl = clone();
      cl.searchBase = base;
      return cl;
    }

    public Search queryEq(String field, String value) {
      Search cl = clone();
      cl.queryString = field + "=" + value;
      return cl;
    }

  }


}
