package org.modellwerkstatt.objectflow.services;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.runtime.IMoLdapService;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;

public class MoLdapService extends LdapAccess implements IMoLdapService {

  private String userInformationSearchbase;


  protected LdapAccess.Search genLdapPrincipal;

  public MoLdapService(String server, String principal, String pwd, String usrInfoSearchBase) {
    this(server, principal, pwd, usrInfoSearchBase, false);
  }
  public MoLdapService(String server, String principal, String pwd, String usrInfoSearchBase, boolean aUseSsl) {
    super(server, aUseSsl);

    userInformationSearchbase = usrInfoSearchBase;
    genLdapPrincipal = new LdapAccess.Search(principal, pwd);
  }

  public void setBindUserPassword(String pwd) {
    genLdapPrincipal = genLdapPrincipal.withPassword(pwd);
  }









  public boolean authenticateUser(String username, String pwd) {
    // prevent anonymous binds with ldap
    if (pwd == null || "".equals(pwd)) {
      return false;
    }


    LdapAccess.Search findDistinguishedName = genLdapPrincipal.withBase(userInformationSearchbase).withReturnAttr("distinguishedName").queryEq("sAMAccountName", username);

    List<String> results = ldapSingleEntrySearch(findDistinguishedName);

    if (ListSequence.fromList(results).count() > 1) {
      throw new IllegalStateException("We have " + ListSequence.fromList(results).count() + " users for the username " + username);

    } else if (ListSequence.fromList(results).count() == 1) {
      LdapAccess.Search userLogin = new LdapAccess.Search(ListSequence.fromList(results).getElement(0), pwd);
      return loginPossible(userLogin);

    } else {
      // username not found ... 
      return false;
    }
  }

  public List<IMoLdapService.ICnInfo> getGroupsOfUser(String username) {

    LdapAccess.Search memberOf = genLdapPrincipal.withBase(userInformationSearchbase).withReturnAttr("memberOf").queryEq("sAMAccountName", username);

    List<String> res = ldapSingleEntrySearch(memberOf);

    return convertCommonName(res);
  }

  public List<IMoLdapService.ICnInfo> getGroupsOfCommonName(String srcBase, String commonName) {

    LdapAccess.Search memberOf = genLdapPrincipal.withBase(srcBase).withReturnAttr("memberOf").queryEq("cn", commonName);

    List<String> res = ldapSingleEntrySearch(memberOf);

    return convertCommonName(res);
  }
  @Override
  public List<IMoLdapService.ICnInfo> getNamesToAttrAndCommonName(String srcBase, String attr, String commonName) {
    LdapAccess.Search memberOf = genLdapPrincipal.withBase(srcBase).withReturnAttr(attr).queryEq("cn", commonName);

    List<String> res = ldapSingleEntrySearch(memberOf);

    return convertCommonName(res);
  }



  protected List<IMoLdapService.ICnInfo> convertCommonName(List<String> rawInfos) {
    final List<IMoLdapService.ICnInfo> infos = ListSequence.fromList(new ArrayList<IMoLdapService.ICnInfo>());
    ListSequence.fromList(rawInfos).visitAll((it) -> ListSequence.fromList(infos).addElement(new CNInformation(it, getCommonName(it))));
    return infos;
  }


  protected String getCommonName(String cnName) {
    if (cnName != null && cnName.toUpperCase().startsWith("CN=")) {
      cnName = cnName.substring(3);
    }
    int position = cnName.indexOf(',');
    if (position == -1) {
      return cnName;
    } else {
      return cnName.substring(0, position);
    }
  }



  public static class CNInformation implements IMoLdapService.ICnInfo {
    private String unprocessedName;
    private String processedName;

    public CNInformation(String unprocessed, String processed) {
      unprocessedName = unprocessed;
      processedName = processed;
    }


    public String getProcessedName() {
      return processedName;
    }
    public String getUnprocessedName() {
      return unprocessedName;
    }
  }
}
