package org.modellwerkstatt.objectflow.services;

/*Generated by MPS */


public class MoMeasure {
  private int max;
  private long[] times;
  private long lastTouch;
  private int replaceIndex;
  private String name;
  private boolean started;
  public MoMeasure(String n, int m) {
    max = m;
    lastTouch = 0;
    started = false;
    name = n + " (@ " + m + " in millis)";
    replaceIndex = 0;
    times = new long[max];
    for (int i = 0; i < max; i++) {
      times[i] = 0;
    }
  }
  public void reset() {
    for (int i = 0; i < max; i++) {
      times[i] = 0;
    }
    lastTouch = 0;
    started = false;
    replaceIndex = 0;
  }
  public void cycle() {
    if (!(started)) {
      started = true;
      start();

    } else {
      stop();
      start();
    }
  }
  public void start() {
    lastTouch = System.currentTimeMillis();
  }
  public void stop() {
    long diff = System.currentTimeMillis() - lastTouch;
    lastTouch = System.currentTimeMillis();

    times[replaceIndex++] = diff;
    if (replaceIndex == max) {
      replaceIndex = 0;
    }
  }
  @Override
  public String toString() {
    return name + ":  " + toLong();
  }
  public long toLong() {
    long avg = 0;
    int cnt = 0;

    for (int i = 0; i < max; i++) {
      if (times[i] == 0) {
        break;
      }
      avg += times[i];
      cnt++;
    }

    if (cnt > 0) {
      avg = avg / cnt;
    }

    return avg;
  }


  public static void main(String[] args) {
    MoMeasure m = new MoMeasure("test", 1);
    m.start();
    try {
      Thread.sleep(300000);
    } catch (InterruptedException e) {
    }
    m.stop();
    System.out.println("" + m);
  }
}
