package org.modellwerkstatt.objectflow.services;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.runtime.IMoEventBusService;
import org.modellwerkstatt.javaxbus.EventBus;
import org.modellwerkstatt.javaxbus.ErrorHandler;
import org.modellwerkstatt.javaxbus.Message;
import org.modellwerkstatt.objectflow.runtime.OFXLogger;
import org.modellwerkstatt.objectflow.runtime.IOFXCoreReporter;
import java.io.IOException;
import java.net.NoRouteToHostException;
import mjson.Json;
import org.modellwerkstatt.javaxbus.ConsumerHandler;

public class MoOptionalEventBus implements IMoEventBusService {
  public static final boolean DEBUG_SENDER_RECEIVER = false;

  private volatile boolean upNrunning;
  private EventBus bus;
  private String sName;
  private int sPort;
  private volatile String systemsInformation = "(no sysinfo set)";
  private volatile String statusInfo = "";


  public MoOptionalEventBus(String serverName, int serverPort) {
    upNrunning = false;
    sName = serverName;
    sPort = serverPort;
    init();
  }

  public String getServerName() {
    return sName;
  }
  public int getServerPort() {
    return sPort;
  }

  public void setSysInfo(String s) {
    systemsInformation = s;
  }
  public void init() {
    try {
      bus = EventBus.create(sName, sPort);

      bus.addErrorHandler(new ErrorHandler() {
        public void handleMsgFromBus(boolean stillConnected, boolean eventLoopRunning, Message msg) {
          String errorText = "Eventbus error msg received: connected-now " + stillConnected + ", bus-receiver-running " + eventLoopRunning + " on [" + systemsInformation + "] ";
          if (msg.isErrorMsg()) {
            errorText += "bus-error-msg '" + msg.getErrMessage() + "', code " + msg.getErrFailureCode() + ", type " + msg.getErrFailureType();
          } else {
            errorText += "message '" + msg.getBodyAsMJson().toString() + "'.";
          }

          if (!(eventLoopRunning)) {
            errorText = "EVENT RECEIVER DISABLED! " + errorText;
          }

          statusInfo = errorText;
          OFXLogger.log(MoOptionalEventBus.class, IOFXCoreReporter.LogPriority.ERROR, errorText, null);

        }
        public void handleException(boolean stillConnected, boolean eventLoopRunning, Exception ex) {
          String errorText = "Eventbus exception: connected-now " + stillConnected + ", bus-receiver-running " + eventLoopRunning + " on [" + systemsInformation + "] ";
          if (!(eventLoopRunning)) {
            errorText = " EVENT RECEIVER DISABLED! " + errorText;
          }

          if (eventLoopRunning && ex instanceof IOException) {
            // skip, event loop is running
          } else if (eventLoopRunning && (ex != null && ex.getCause() instanceof NoRouteToHostException)) {
            // server not reachable, we are connecting anyway. 
          } else {
            OFXLogger.log(MoOptionalEventBus.class, IOFXCoreReporter.LogPriority.ERROR, errorText, ex);
          }

          statusInfo = errorText + " (" + ex + ")";
        }
      });

      upNrunning = true;

    } catch (Exception ex) {
      bus = null;
      upNrunning = false;
      statusInfo = ex.getClass().getSimpleName() + " " + ex.getMessage();

      OFXLogger.log(MoOptionalEventBus.class, IOFXCoreReporter.LogPriority.ERROR, "Was not able to connect to eventbus at " + sName + ":" + sPort + ".", ex);
    }



  }

  public boolean sendToLogChannel(String ch, Json msg) {
    // even if not up, we do not log messages locally. 
    boolean sent;
    if (!(upNrunning)) {
      sent = false;

    } else if (bus.isConnected()) {
      try {
        bus.send(ch, msg);
        sent = true;

      } catch (RuntimeException ex) {
        OFXLogger.log(MoOptionalEventBus.class, IOFXCoreReporter.LogPriority.FATAL, "Exception while trying to write to global log. This seriously impacts portJ monitoring.", ex);
        sent = false;

      }


    } else {
      sent = false;
    }

    if (!(sent)) {
      OFXLogger.log(MoOptionalEventBus.class, IOFXCoreReporter.LogPriority.FATAL, "Investigatingh h2forms portj issues (Spring 25), message NOT sent!.  Now upnRunning=" + upNrunning + ", bus.isconnected()=" + bus.isConnected() + ". Tried to send " + OFXLogger.simpleInfo(msg) + ".", null);

    }

    return sent;
  }
  public void publish(String msgType, Json json) {
    if (!(upNrunning)) {
      return;
    }
    if (bus.isConnected()) {
      try {
        dd("publish " + json);
        bus.publish(msgType, json);

      } catch (RuntimeException ex) {
        OFXLogger.log(MoOptionalEventBus.class, IOFXCoreReporter.LogPriority.ERROR, "Exception while trying to publish to " + msgType + " the msg " + json.toString(), ex);

      }

    }
  }

  public void register(ConsumerHandler recv, String msgType) {
    if (upNrunning && bus.isConnected()) {
      bus.consumer(msgType, recv);
    }
  }

  public void unregister(ConsumerHandler recv, String msgType) {

    if (upNrunning && bus.isConnected()) {
      bus.unregisgterConsumer(msgType, recv);
    }
  }

  public String getCurrentStatus() {
    String stat = sName + ":" + sPort + ", up " + upNrunning;
    if (bus != null && upNrunning) {
      stat += ", con " + bus.isConnected();
    }
    stat += ", [" + statusInfo + "]";
    return stat;
  }

  public String testReset() {
    String msg = "No top level ex while resetting. Check logs. ";
    if (bus == null) {
      msg = "Eventbus not correctly initialized (bus is null)";
    } else {
      try {
        bus.testReconnect();
        msg += " [up " + upNrunning + ", con " + bus.isConnected() + ", conup " + bus.isUpAndRunning() + "]";

      } catch (Exception ex) {
        msg = ex.getClass().getName() + ": " + ex.getMessage();
        statusInfo = msg + " after testRest()";

      }
    }

    return msg;
  }

  public static void dd(String msg) {
    if (DEBUG_SENDER_RECEIVER) {
      System.err.println("MoOEb.debug(): " + msg);
    }
  }

  public void close() {
    if (bus != null && upNrunning) {
      // bus handles dereg of handlers ...
      bus.close();
    }
  }
}
