package org.modellwerkstatt.objectflow.services;

/*Generated by MPS */

import org.modellwerkstatt.objectflow.runtime.OFXInteger;
import org.modellwerkstatt.objectflow.runtime.OFXBigDecimal;
import org.modellwerkstatt.objectflow.runtime.OFXString;
import org.modellwerkstatt.objectflow.runtime.OFXLocalDate;
import org.modellwerkstatt.objectflow.runtime.OFXDateTime;
import org.modellwerkstatt.objectflow.runtime.OFXStatus;
import org.modellwerkstatt.objectflow.runtime.OFXKeyReference;
import org.modellwerkstatt.objectflow.runtime.OFXValueObject;
import org.modellwerkstatt.objectflow.runtime.OFXList;
import org.modellwerkstatt.objectflow.runtime.OFXVPBase;

public class MoStringIntroPrinter implements IMoIntrospectionPrinter {
  private static final String INDENT = "   ";

  private MoGraphIntrospector introspector;
  private StringBuilder sb = new StringBuilder();
  private Object rootObject;

  public MoStringIntroPrinter(Object rootObj) {
    introspector = new MoGraphIntrospector();
    this.rootObject = rootObj;
  }


  public void handleIntro(String indent, String objectName, String simpleFields) {
    sb.append(indent + objectName + "  (" + simpleFields + ")\n");
  }
  public void handleInteger(String indent, String fieldname, OFXInteger value, boolean isKey) {
    sb.append(indent + fieldname + ": " + value.getValue() + "\n");
  }
  public void handleBigDecimal(String indent, String fieldname, OFXBigDecimal value, boolean isKey) {
    sb.append(indent + fieldname + ": " + value.getValue() + "\n");
  }
  public void handleString(String indent, String fieldname, OFXString value, boolean isKey) {
    sb.append(indent + fieldname + ": " + value.getValue() + "\n");
  }
  public void handleLocalDate(String indent, String fieldname, OFXLocalDate value) {
    sb.append(indent + fieldname + ": " + value.getValue() + "\n");
  }
  public void handleDateTime(String indent, String fieldname, OFXDateTime value) {
    sb.append(indent + fieldname + ": " + value.getValue() + "\n");
  }
  public void handleStatus(String indent, String fieldname, OFXStatus ofxStatus, boolean isKey) {
    String dbValue = "(null)";
    if (ofxStatus.getValue() != null) {
      dbValue = ofxStatus.getValue().getDbValue();
    }
    sb.append(indent + fieldname + ": " + dbValue + "\n");
  }
  public void handleKefReference(String indent, String fieldname, OFXKeyReference value) {
    sb.append(indent + fieldname + " (Reference): Key:" + value.getKey() + "\n");
    if (!(value.getOpposite()) && value.isInitialized()) {
      introspector.introspectionPrint(indent + INDENT, value.getValue(), this);
    }

  }
  public void handleValueObject(String indent, String fieldname, OFXValueObject value, boolean isKey) {
    sb.append(indent + fieldname + " (ValueObject): \n");
    // introspect value object
    introspector.introspectionPrint(indent + INDENT, value.getValue(), this);
  }
  public void handleList(String indent, String fieldname, OFXList value) {
    if (value.getValue() == null) {
      sb.append(indent + fieldname + " (List): NULL !\n");

    } else {
      sb.append(indent + fieldname + " (List): \n");
      for (Object obj : value.getValue()) {
        introspector.introspectionPrint(indent + INDENT, obj, this);
        sb.append("\n");
      }
    }
  }
  public void handleVirtualProperty(String indent, String fieldname, OFXVPBase meta, Object value, boolean isKey) {
    sb.append(indent + fieldname + " (Virt.Prop.) " + value + "\n");
  }

  public void handleOutro() {
  }

  public String printGraph() {
    introspector.introspectionPrint("", this.rootObject, this);
    return sb.toString();
  }
}
