package org.modellwerkstatt.objectflow.intentions;

/*Generated by MPS */

import jetbrains.mps.intentions.AbstractIntentionDescriptor;
import jetbrains.mps.openapi.intentions.IntentionFactory;
import java.util.Collection;
import jetbrains.mps.openapi.intentions.IntentionExecutable;
import jetbrains.mps.openapi.intentions.Kind;
import jetbrains.mps.smodel.SNodePointer;
import org.jetbrains.mps.openapi.model.SNode;
import jetbrains.mps.openapi.editor.EditorContext;
import java.util.Collections;
import jetbrains.mps.intentions.AbstractIntentionExecutable;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SModelOperations;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.baseLanguage.behavior.Classifier__BehaviorDescriptor;
import org.modellwerkstatt.objectflow.util.AutoCreatorStateService;
import org.modellwerkstatt.objectflow.util.OFXLegacyHelper;
import jetbrains.mps.openapi.intentions.IntentionDescriptor;
import org.jetbrains.mps.openapi.language.SConcept;
import org.jetbrains.mps.openapi.language.SProperty;
import org.jetbrains.mps.openapi.language.SContainmentLink;
import org.jetbrains.mps.openapi.language.SReferenceLink;

public final class AutoCreateStateProc_Intention extends AbstractIntentionDescriptor implements IntentionFactory {
  private Collection<IntentionExecutable> myCachedExecutable;

  public AutoCreateStateProc_Intention() {
    super(Kind.NORMAL, true, new SNodePointer("r:034603ed-8e73-486e-af2c-268865f08e38(org.modellwerkstatt.objectflow.intentions)", "1719730829700521237"));
  }

  @Override
  public String getPresentation() {
    return "AutoCreateStateProc";
  }

  @Override
  public boolean isSurroundWith() {
    return false;
  }

  public Collection<IntentionExecutable> instances(final SNode node, final EditorContext context) {
    if (myCachedExecutable == null) {
      myCachedExecutable = Collections.<IntentionExecutable>singletonList(new IntentionImplementation());
    }
    return myCachedExecutable;
  }
  /*package*/ final class IntentionImplementation extends AbstractIntentionExecutable {
    public IntentionImplementation() {
    }

    @Override
    public String getDescription(final SNode node, final EditorContext editorContext) {
      return "Create State-Service for status property";
    }

    @Override
    public void execute(final SNode node, final EditorContext editorContext) {
      final SNode entity = SNodeOperations.getNodeAncestor(node, CONCEPTS.Entity$WP, false, false);
      final String name = SPropertyOperations.getString(entity, PROPS.name$MnvL).trim() + "Srv";

      final Wrappers._T<SNode> srv = new Wrappers._T<SNode>(ListSequence.fromList(SModelOperations.roots(SNodeOperations.getModel(node), CONCEPTS.Service$HK)).findFirst((it) -> name.equals(SPropertyOperations.getString(it, PROPS.name$MnvL))));

      if (srv.value == null) {
        srv.value = SModelOperations.createNewRootNode(SNodeOperations.getModel(node), MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3eafb777941be31fL, "org.modellwerkstatt.objectflow.structure.Service"));
        SPropertyOperations.assign(srv.value, PROPS.name$MnvL, name);
      }

      ListSequence.fromList(SLinkOperations.getChildren(SLinkOperations.getTarget(SNodeOperations.cast(SLinkOperations.getTarget(node, LINKS.type$56v0), CONCEPTS.StatusType$Mp), LINKS.status$PoDo), LINKS.element$GLWK)).visitAll((elem) -> {
        final String operationName = SPropertyOperations.getString(elem, PROPS.name$MnvL).toLowerCase();

        SNode method = Sequence.fromIterable(Classifier__BehaviorDescriptor.methods_id4_LVZ3pBKCn.invoke(srv.value)).findFirst((it) -> operationName.equals(SPropertyOperations.getString(it, PROPS.name$MnvL)));
        if (method == null) {
          method = AutoCreatorStateService.addDocMethod(srv.value, operationName, entity);
          ListSequence.fromList(SLinkOperations.getChildren(SLinkOperations.getTarget(method, LINKS.body$5xQk), LINKS.statement$53DE)).addElement(AutoCreatorStateService.createStatusChange(ListSequence.fromList(SLinkOperations.getChildren(method, LINKS.parameter$5xBj)).first(), node, elem));
        }
      });

    }

    @Override
    public boolean isApplicable(final SNode node, final EditorContext editorContext) {
      if (!(isApplicableToNode(node, editorContext))) {
        return false;
      }
      return true;
    }

    private boolean isApplicableToNode(final SNode node, final EditorContext editorContext) {
      return OFXLegacyHelper.isStatus(SLinkOperations.getTarget(node, LINKS.type$56v0));
    }


    @Override
    public IntentionDescriptor getDescriptor() {
      return AutoCreateStateProc_Intention.this;
    }

  }

  private static final class CONCEPTS {
    /*package*/ static final SConcept Entity$WP = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x130a62a9d793b6e4L, "org.modellwerkstatt.objectflow.structure.Entity");
    /*package*/ static final SConcept Service$HK = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3eafb777941be31fL, "org.modellwerkstatt.objectflow.structure.Service");
    /*package*/ static final SConcept StatusType$Mp = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3ee8b55a8397033dL, "org.modellwerkstatt.objectflow.structure.StatusType");
  }

  private static final class PROPS {
    /*package*/ static final SProperty name$MnvL = MetaAdapterFactory.getProperty(0xceab519525ea4f22L, 0x9b92103b95ca8c0cL, 0x110396eaaa4L, 0x110396ec041L, "name");
  }

  private static final class LINKS {
    /*package*/ static final SContainmentLink type$56v0 = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x117b744dafeL, 0x117b752a0b9L, "type");
    /*package*/ static final SReferenceLink status$PoDo = MetaAdapterFactory.getReferenceLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3ee8b55a8397033dL, 0x5b98aafabfcedbd3L, "status");
    /*package*/ static final SContainmentLink element$GLWK = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3ee8b55a8395b855L, 0x3ee8b55a8395b858L, "element");
    /*package*/ static final SContainmentLink body$5xQk = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc56b1fcL, 0xf8cc56b1ffL, "body");
    /*package*/ static final SContainmentLink statement$53DE = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc56b200L, 0xf8cc6bf961L, "statement");
    /*package*/ static final SContainmentLink parameter$5xBj = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc56b1fcL, 0xf8cc56b1feL, "parameter");
  }
}
