package org.modellwerkstatt.objectflow.intentions;

/*Generated by MPS */

import jetbrains.mps.intentions.AbstractIntentionDescriptor;
import jetbrains.mps.openapi.intentions.IntentionFactory;
import java.util.Collection;
import jetbrains.mps.openapi.intentions.IntentionExecutable;
import jetbrains.mps.openapi.intentions.Kind;
import jetbrains.mps.smodel.SNodePointer;
import org.jetbrains.mps.openapi.model.SNode;
import jetbrains.mps.openapi.editor.EditorContext;
import java.util.Collections;
import jetbrains.mps.intentions.AbstractIntentionExecutable;
import jetbrains.mps.internal.collections.runtime.Sequence;
import org.modellwerkstatt.objectflow.behavior.OFXTestSuit__BehaviorDescriptor;
import org.modellwerkstatt.objectflow.behavior.OFXTestMethod__BehaviorDescriptor;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import jetbrains.mps.openapi.intentions.IntentionDescriptor;

public final class DontExecRemoveAll_Intention extends AbstractIntentionDescriptor implements IntentionFactory {
  private Collection<IntentionExecutable> myCachedExecutable;

  public DontExecRemoveAll_Intention() {
    super(Kind.NORMAL, true, new SNodePointer("r:034603ed-8e73-486e-af2c-268865f08e38(org.modellwerkstatt.objectflow.intentions)", "59360650272366092"));
  }

  @Override
  public String getPresentation() {
    return "DontExecRemoveAll";
  }

  @Override
  public boolean isSurroundWith() {
    return false;
  }

  public Collection<IntentionExecutable> instances(final SNode node, final EditorContext context) {
    if (myCachedExecutable == null) {
      myCachedExecutable = Collections.<IntentionExecutable>singletonList(new IntentionImplementation());
    }
    return myCachedExecutable;
  }
  /*package*/ final class IntentionImplementation extends AbstractIntentionExecutable {
    public IntentionImplementation() {
    }

    @Override
    public String getDescription(final SNode node, final EditorContext editorContext) {
      return "dont exec: Remove from ALL executable tests.";
    }

    @Override
    public void execute(final SNode node, final EditorContext editorContext) {
      SNode editorNode = editorContext.getSelectedNode();

      Sequence.fromIterable(OFXTestSuit__BehaviorDescriptor.getTestMethods_id3iT39Dw7Yu.invoke(node)).visitAll((it) -> {
        SNode dontExec = OFXTestMethod__BehaviorDescriptor.getDontExecOption_id3iT39CYXhK.invoke(it);
        if (dontExec != null) {
          SNodeOperations.deleteNode(dontExec);
        }
      });

      editorContext.select(editorNode);
    }

    @Override
    public boolean isApplicable(final SNode node, final EditorContext editorContext) {
      return true;
    }



    @Override
    public IntentionDescriptor getDescriptor() {
      return DontExecRemoveAll_Intention.this;
    }

  }
}
