package org.modellwerkstatt.objectflow.intentions;

/*Generated by MPS */

import jetbrains.mps.intentions.AbstractIntentionDescriptor;
import jetbrains.mps.openapi.intentions.IntentionFactory;
import java.util.Collection;
import jetbrains.mps.openapi.intentions.IntentionExecutable;
import jetbrains.mps.openapi.intentions.Kind;
import jetbrains.mps.smodel.SNodePointer;
import org.jetbrains.mps.openapi.model.SNode;
import jetbrains.mps.openapi.editor.EditorContext;
import java.util.Collections;
import jetbrains.mps.intentions.AbstractIntentionExecutable;
import org.modellwerkstatt.objectflow.behavior.OFXTestMethod__BehaviorDescriptor;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import jetbrains.mps.openapi.intentions.IntentionDescriptor;

public final class DontExecToggle_Intention extends AbstractIntentionDescriptor implements IntentionFactory {
  private Collection<IntentionExecutable> myCachedExecutable;

  public DontExecToggle_Intention() {
    super(Kind.NORMAL, true, new SNodePointer("r:034603ed-8e73-486e-af2c-268865f08e38(org.modellwerkstatt.objectflow.intentions)", "59360650270156908"));
  }

  @Override
  public String getPresentation() {
    return "DontExecToggle";
  }

  @Override
  public boolean isSurroundWith() {
    return false;
  }

  public Collection<IntentionExecutable> instances(final SNode node, final EditorContext context) {
    if (myCachedExecutable == null) {
      myCachedExecutable = Collections.<IntentionExecutable>singletonList(new IntentionImplementation());
    }
    return myCachedExecutable;
  }
  /*package*/ final class IntentionImplementation extends AbstractIntentionExecutable {
    public IntentionImplementation() {
    }

    @Override
    public String getDescription(final SNode node, final EditorContext editorContext) {
      // You can always remove do not exec ...
      if (OFXTestMethod__BehaviorDescriptor.getDontExecOption_id3iT39CYXhK.invoke(node) != null) {
        return "dont exec: Remove from this test.";
      }
      return "dont exec: Add to this test.";
    }

    @Override
    public void execute(final SNode node, final EditorContext editorContext) {
      SNode editorNode = editorContext.getSelectedNode();

      SNode dontExecOption = OFXTestMethod__BehaviorDescriptor.getDontExecOption_id3iT39CYXhK.invoke(node);
      if (dontExecOption != null) {
        SNodeOperations.deleteNode(dontExecOption);
      } else {
        // create Debug Option
        OFXTestMethod__BehaviorDescriptor.addDontExecOption_id3iT39CYXir.invoke(node);
      }

      editorContext.select(editorNode);
    }

    @Override
    public boolean isApplicable(final SNode node, final EditorContext editorContext) {
      if (!(isApplicableToNode(node, editorContext))) {
        return false;
      }
      return true;
    }

    private boolean isApplicableToNode(final SNode node, final EditorContext editorContext) {
      if (OFXTestMethod__BehaviorDescriptor.getDontExecOption_id3iT39CYXhK.invoke(node) != null || (boolean) OFXTestMethod__BehaviorDescriptor.isPotentiallyToExecute_id3iT39CYUne.invoke(node)) {
        return true;
      }
      return false;
    }


    @Override
    public IntentionDescriptor getDescriptor() {
      return DontExecToggle_Intention.this;
    }

  }
}
