package org.modellwerkstatt.objectflow.plugin;

/*Generated by MPS */

import com.intellij.openapi.ui.DialogBuilder;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import jetbrains.mps.project.MPSProject;
import java.awt.Dimension;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import javax.swing.JLabel;
import jetbrains.mps.ide.datatransfer.TextPasteUtil;
import javax.swing.JScrollPane;
import com.intellij.ui.ScrollPaneFactory;

public class CopyPasteDialog extends DialogBuilder {
  private JComponent myComponent;
  public JTextArea myText;
  private boolean isOkayButton = false;

  public CopyPasteDialog(MPSProject project, String title) {
    super(project.getProject());
    this.myComponent = this.createPanel();
    this.setCenterPanel(this.myComponent);
    this.myComponent.setMinimumSize(new Dimension(800, 600));
    this.setTitle(title);
  }

  public CopyPasteDialog(MPSProject project, String title, String text) {
    this(project, title);
    this.myText.setText(text);
  }

  protected JComponent getMainComponent() {
    return this.myComponent;
  }

  public JComponent createPanel() {
    JPanel panel = new JPanel(new BorderLayout());
    panel.add(new JLabel("Paste your data here:"), BorderLayout.NORTH);
    this.myText = new JTextArea("");
    String str = TextPasteUtil.getStringFromClipboard();
    if (str != null) {
      this.myText.setText(str);
    }
    panel.add(this.myText, BorderLayout.CENTER);
    JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(panel);
    scrollPane.getVerticalScrollBar().setBlockIncrement(40);
    scrollPane.getVerticalScrollBar().setUnitIncrement(20);
    scrollPane.getHorizontalScrollBar().setBlockIncrement(40);
    return scrollPane;
  }

  public boolean isOkay() {
    return isOkayButton;
  }

  public void showDialog() {
    isOkayButton = super.showAndGet();
  }
}
