package org.modellwerkstatt.objectflow.plugin;

/*Generated by MPS */

import jetbrains.mps.workbench.action.BaseAction;
import javax.swing.Icon;
import jetbrains.mps.workbench.action.ActionAccess;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.Map;
import java.awt.Frame;
import jetbrains.mps.ide.actions.MPSCommonDataKeys;
import jetbrains.mps.project.MPSProject;
import org.jetbrains.mps.openapi.model.SNode;
import org.jetbrains.annotations.NotNull;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import javax.swing.JOptionPane;
import org.jetbrains.mps.openapi.model.SModel;
import jetbrains.mps.smodel.action.SNodeFactoryOperations;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import org.modellwerkstatt.objectflow.util.SQLDescTableParser;
import org.jetbrains.mps.openapi.language.SConcept;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import org.jetbrains.mps.openapi.language.SContainmentLink;

public class DbDescribeToDTO_Action extends BaseAction {
  private static final Icon ICON = null;

  public DbDescribeToDTO_Action() {
    super("Werkbank - Create DTO / NoKeyMapper from DESC", "DTO from SQL desc table", ICON);
    this.setIsAlwaysVisible(true);
    this.setActionAccess(ActionAccess.UNDO_PROJECT);
    updateInBackground(true);
  }
  @Override
  public boolean isDumbAware() {
    return true;
  }
  @Override
  protected boolean collectActionData(AnActionEvent event, final Map<String, Object> _params) {
    if (!(super.collectActionData(event, _params))) {
      return false;
    }
    {
      Frame p = event.getData(MPSCommonDataKeys.FRAME);
      if (p == null) {
        return false;
      }
    }
    {
      MPSProject p = event.getData(MPSCommonDataKeys.MPS_PROJECT);
      if (p == null) {
        return false;
      }
    }
    {
      SNode p = event.getData(MPSCommonDataKeys.NODE);
    }
    return true;
  }
  @Override
  public void doExecute(@NotNull final AnActionEvent event, final Map<String, Object> _params) {
    SNode modelRepository = event.getData(MPSCommonDataKeys.NODE);

    if (modelRepository == null || !(SNodeOperations.isInstanceOf(modelRepository, CONCEPTS.Repository$WM))) {
      JOptionPane.showMessageDialog(event.getData(MPSCommonDataKeys.FRAME), "Selected a Respository where NoKeyMapper should be put in . . .", "Wrong selection in project explorer", JOptionPane.ERROR_MESSAGE);
      return;
    }



    // ok, use dialog and create nodes
    CopyPasteDialog dialog = new CopyPasteDialog(event.getData(MPSCommonDataKeys.MPS_PROJECT), "Paste SQL here...");
    dialog.showDialog();

    SModel mod = SNodeOperations.getModel(modelRepository);

    if (dialog.isOkay()) {
      String content = dialog.myText.getText().toString();

      SNode createdViewObject = SNodeFactoryOperations.createNewRootNode(mod, CONCEPTS.DTO$UE, null);
      ListSequence.fromList(SLinkOperations.getChildren(createdViewObject, LINKS.businessProperties$cI4J)).clear();

      SNode noKeyMapper = SNodeFactoryOperations.addNewChild(SNodeOperations.cast(modelRepository, CONCEPTS.Repository$WM), LINKS.member$L_2d, CONCEPTS.NoKeyMapperField$_P);

      try {
        SQLDescTableParser parser = new SQLDescTableParser(content);
        parser.parse(createdViewObject, noKeyMapper);


      } catch (Exception e) {
        e.printStackTrace();
        SNodeOperations.deleteNode(createdViewObject);
        SNodeOperations.deleteNode(noKeyMapper);

        JOptionPane.showMessageDialog(event.getData(MPSCommonDataKeys.FRAME), e.getMessage(), "Problem while parsing ... ", JOptionPane.ERROR_MESSAGE);

      }

    }

  }

  private static final class CONCEPTS {
    /*package*/ static final SConcept Repository$WM = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x3d5d71b314aa1113L, "org.modellwerkstatt.manmap.structure.Repository");
    /*package*/ static final SConcept DTO$UE = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x488302ba36b9283fL, "org.modellwerkstatt.objectflow.structure.DTO");
    /*package*/ static final SConcept NoKeyMapperField$_P = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xad9572552c31468L, "org.modellwerkstatt.manmap.structure.NoKeyMapperField");
  }

  private static final class LINKS {
    /*package*/ static final SContainmentLink businessProperties$cI4J = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3bdce9a978275e87L, 0x2c8253fb15073741L, "businessProperties");
    /*package*/ static final SContainmentLink member$L_2d = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x101d9d3ca30L, 0x4a9a46de59132803L, "member");
  }
}
