package org.modellwerkstatt.objectflow.plugin;

/*Generated by MPS */

import jetbrains.mps.workbench.action.BaseAction;
import javax.swing.Icon;
import jetbrains.mps.workbench.action.ActionAccess;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.Map;
import jetbrains.mps.project.MPSProject;
import jetbrains.mps.ide.actions.MPSCommonDataKeys;
import java.awt.Frame;
import org.jetbrains.annotations.NotNull;
import java.util.List;
import org.jetbrains.mps.openapi.model.SModel;
import org.joda.time.LocalDate;
import org.jetbrains.mps.openapi.model.SNode;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SModelOperations;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import jetbrains.mps.lang.core.behavior.INamedConcept__BehaviorDescriptor;
import javax.swing.JOptionPane;
import org.modellwerkstatt.objectflow.runtime.OFXConsoleHelper;
import org.jetbrains.mps.openapi.language.SConcept;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import org.jetbrains.mps.openapi.language.SContainmentLink;
import org.jetbrains.mps.openapi.language.SProperty;

public class ExportProjectStatiToDB_Action extends BaseAction {
  private static final Icon ICON = null;

  public ExportProjectStatiToDB_Action() {
    super("Werkbank - Export project stati", "Export project stati for Oracle", ICON);
    this.setIsAlwaysVisible(true);
    this.setActionAccess(ActionAccess.UNDO_PROJECT);
    updateInBackground(true);
  }
  @Override
  public boolean isDumbAware() {
    return true;
  }
  @Override
  protected boolean collectActionData(AnActionEvent event, final Map<String, Object> _params) {
    if (!(super.collectActionData(event, _params))) {
      return false;
    }
    {
      MPSProject p = event.getData(MPSCommonDataKeys.MPS_PROJECT);
      if (p == null) {
        return false;
      }
    }
    {
      Frame p = event.getData(MPSCommonDataKeys.FRAME);
      if (p == null) {
        return false;
      }
    }
    return true;
  }
  @Override
  public void doExecute(@NotNull final AnActionEvent event, final Map<String, Object> _params) {
    final StringBuilder bldr = new StringBuilder();

    try {
      List<SModel> allRelevantModels = MoMdlAccess.relevantModels(event.getData(MPSCommonDataKeys.MPS_PROJECT), true);



      // (1) Project summary - header information 
      bldr.append("MoWare Werkbank - simple oracle db export for all stati  " + "run @ " + new LocalDate() + "\n");
      bldr.append("for project " + event.getData(MPSCommonDataKeys.MPS_PROJECT).getName() + "\n");
      bldr.append("\n\n");

      String schema = "";
      schema += "DROP TABLE PROJECT_STATUSDECLARATIONS;\n";
      schema += "CREATE TABLE PROJECT_STATUSDECLARATIONS(\n";
      schema += " FQ_NAME VARCHAR2  (250 CHAR) /* fqName */,\n";
      schema += " STATUS VARCHAR2  (50 CHAR) /* status */,\n";
      schema += " DB_VALUE VARCHAR2  (50 CHAR) /* dbValue */,\n";
      schema += " SHORT_DESC VARCHAR2  (50 CHAR) /* shortDesc */,\n";
      schema += " LONG_DESC VARCHAR2  (50 CHAR) /* longDesc */,\n";
      schema += "\n";
      schema += " CONSTRAINT PK_PROJECT_STATUSDECLARATIONS PRIMARY KEY (FQ_NAME, STATUS)\n";
      schema += ");\n\n";

      bldr.append(schema);
      bldr.append("\n\n");

      for (SModel mod : allRelevantModels) {
        List<SNode> sds = SModelOperations.nodes(mod, CONCEPTS.StatusDeclaration$of);

        ListSequence.fromList(sds).visitAll((final SNode status) -> {
          ListSequence.fromList(SLinkOperations.getChildren(status, LINKS.element$GLWK)).visitAll((elem) -> {

            // INSERT INTO "REKO"."PROJECT_STATUSDECLARATIONS" (FQ_NAME, STATUS, DB_VALUE, SHORT_DESC, LONG_DESC) VALUES ('a', 'b', 'c', 'd', 'e')
            String shortDesc = ((SLinkOperations.getTarget(elem, LINKS.shortDescNew$mKyp) == null) ? "" : SPropertyOperations.getString(SLinkOperations.getTarget(elem, LINKS.shortDescNew$mKyp), PROPS.value$w7MM));
            String longDesc = ((SLinkOperations.getTarget(elem, LINKS.longDescNew$pIm2) == null) ? "" : SPropertyOperations.getString(SLinkOperations.getTarget(elem, LINKS.longDescNew$pIm2), PROPS.value$w7MM));

            String sql = String.format("INSERT INTO \"PROJECT_STATUSDECLARATIONS\" (FQ_NAME, STATUS, DB_VALUE, SHORT_DESC, LONG_DESC) VALUES ('%s', '%s', '%s', '%s', '%s');\n", INamedConcept__BehaviorDescriptor.getFqName_idhEwIO9y.invoke(status), SPropertyOperations.getString(elem, PROPS.name$MnvL), SPropertyOperations.getString(elem, PROPS.value$GToT), shortDesc, longDesc);
            bldr.append(sql);
          });


        });
      }

      CopyPasteDialog dialog = new CopyPasteDialog(event.getData(MPSCommonDataKeys.MPS_PROJECT), "Generated report");
      dialog.myText.setText(bldr.toString());
      dialog.showDialog();


    } catch (NullPointerException npe) {
      npe.printStackTrace();
      JOptionPane.showMessageDialog(event.getData(MPSCommonDataKeys.FRAME), "NPE \n" + OFXConsoleHelper.stackTrace2String(npe), "Problem while generating report ..", JOptionPane.ERROR_MESSAGE);

    } catch (Throwable t) {
      t.printStackTrace();
      JOptionPane.showMessageDialog(event.getData(MPSCommonDataKeys.FRAME), t.getMessage(), "Problem while generating report . ", JOptionPane.ERROR_MESSAGE);
    }

  }

  private static final class CONCEPTS {
    /*package*/ static final SConcept StatusDeclaration$of = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3ee8b55a8395b855L, "org.modellwerkstatt.objectflow.structure.StatusDeclaration");
  }

  private static final class LINKS {
    /*package*/ static final SContainmentLink element$GLWK = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3ee8b55a8395b855L, 0x3ee8b55a8395b858L, "element");
    /*package*/ static final SContainmentLink shortDescNew$mKyp = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3ee8b55a8395b856L, 0x59515864ae979be1L, "shortDescNew");
    /*package*/ static final SContainmentLink longDescNew$pIm2 = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3ee8b55a8395b856L, 0x59515864ae979c16L, "longDescNew");
  }

  private static final class PROPS {
    /*package*/ static final SProperty value$w7MM = MetaAdapterFactory.getProperty(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf93d565d10L, 0xf93d565d11L, "value");
    /*package*/ static final SProperty name$MnvL = MetaAdapterFactory.getProperty(0xceab519525ea4f22L, 0x9b92103b95ca8c0cL, 0x110396eaaa4L, 0x110396ec041L, "name");
    /*package*/ static final SProperty value$GToT = MetaAdapterFactory.getProperty(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3ee8b55a8395b856L, 0x3ee8b55a8395b862L, "value");
  }
}
