package org.modellwerkstatt.objectflow.plugin;

/*Generated by MPS */

import com.intellij.openapi.ui.DialogBuilder;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JCheckBox;
import jetbrains.mps.project.MPSProject;
import java.awt.Dimension;
import javax.swing.JPanel;
import java.awt.BorderLayout;
import javax.swing.JLabel;
import jetbrains.mps.ide.datatransfer.TextPasteUtil;
import javax.swing.JScrollPane;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.GridLayout;

public class JSONImportDialog extends DialogBuilder {
  private JComponent myComponent;
  public JTextArea myText;
  public JTextField dateTimeFormat;
  public JTextField localDateFormat;
  public JTextField bigDeciFormat;
  public JCheckBox allEncompassing;

  private boolean isOkayButton = false;

  public JSONImportDialog(MPSProject project, String title) {
    super(project.getProject());
    this.myComponent = this.createPanel();
    this.setCenterPanel(this.myComponent);
    this.myComponent.setMinimumSize(new Dimension(800, 600));
    this.setTitle(title);
  }

  public JSONImportDialog(MPSProject project, String title, String text) {
    super(project.getProject());
    this.myComponent = this.createPanel();
    this.setCenterPanel(this.myComponent);
    this.myText.setText(text);
    this.setTitle(title);
  }

  protected JComponent getMainComponent() {
    return this.myComponent;
  }

  public JComponent createPanel() {
    JPanel mainPanel = new JPanel(new BorderLayout());

    mainPanel.add(new JLabel("Paste your data here:"), BorderLayout.NORTH);
    this.myText = new JTextArea("");
    String str = TextPasteUtil.getStringFromClipboard();
    if (str != null) {
      this.myText.setText(str);
    }

    JScrollPane scrollPane = ScrollPaneFactory.createScrollPane(this.myText);
    scrollPane.getVerticalScrollBar().setBlockIncrement(40);
    scrollPane.getVerticalScrollBar().setUnitIncrement(20);
    scrollPane.getHorizontalScrollBar().setBlockIncrement(40);

    mainPanel.add(scrollPane, BorderLayout.CENTER);


    JPanel optionsPanel = new JPanel(new GridLayout(4, 2));

    optionsPanel.add(new JLabel("DateTime Format"));
    dateTimeFormat = new JTextField("dd.MM.yyyy hh:mm:ss");
    optionsPanel.add(dateTimeFormat);

    optionsPanel.add(new JLabel("LocalDate Format"));
    localDateFormat = new JTextField("dd.MM.yy");
    optionsPanel.add(localDateFormat);

    optionsPanel.add(new JLabel("BigDecimal Format"));
    bigDeciFormat = new JTextField("#,##0.00");
    optionsPanel.add(bigDeciFormat);

    optionsPanel.add(new JLabel("Build max encompassing obj."));
    allEncompassing = new JCheckBox();
    allEncompassing.setSelected(false);
    optionsPanel.add(allEncompassing);


    mainPanel.add(optionsPanel, BorderLayout.SOUTH);



    return mainPanel;
  }

  public boolean isOkay() {
    return isOkayButton;
  }

  public void showDialog() {
    isOkayButton = super.showAndGet();
  }
}
