package org.modellwerkstatt.objectflow.plugin;

/*Generated by MPS */

import jetbrains.mps.refactoring.participant.plugin.MoveNodesAction;
import jetbrains.mps.smodel.structure.Extension;
import jetbrains.mps.project.MPSProject;
import java.util.List;
import org.jetbrains.mps.openapi.model.SNode;
import jetbrains.mps.baseLanguage.closures.runtime.Wrappers;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import jetbrains.mps.ide.platform.refactoring.MoveNodeDialog;
import org.jetbrains.mps.openapi.model.SModel;
import jetbrains.mps.refactoring.participant.plugin.MoveNodesUtil;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import java.util.HashMap;
import java.util.Map;
import java.util.ArrayList;
import jetbrains.mps.refactoring.participant.RefactoringParticipant;
import jetbrains.mps.refactoring.participant.RefactoringSession;
import jetbrains.mps.refactoring.participant.NodeCopyTracker;
import org.jetbrains.mps.openapi.language.SConcept;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;

public class MoveServRepoMethod implements MoveNodesAction {

  public static class MoveServiceMethod_Extensions extends Extension.Default<MoveNodesAction> {
    public MoveServiceMethod_Extensions() {
      super("jetbrains.mps.refactoring.participant.MoveNodesActionEP");
    }
    public MoveNodesAction get() {
      return new MoveServRepoMethod();
    }
  }


  @Override
  public String getName() {
    return "Move Service/Repo Method";
  }
  @Override
  public boolean isApplicable(MPSProject project, final List<SNode> target) {
    final Wrappers._boolean result = new Wrappers._boolean();
    project.getRepository().getModelAccess().runReadAction(() -> result.value = ListSequence.fromList(target).count() == 1 && (SNodeOperations.isInstanceOf(ListSequence.fromList(target).first(), CONCEPTS.ServiceInstanceMethodDeclaration$ww) || SNodeOperations.isInstanceOf(ListSequence.fromList(target).first(), CONCEPTS.RepositoryInstanceMethodDeclaration$Xh)));
    return result.value;
  }
  @Override
  public void execute(MPSProject project, List<SNode> nodes) {
    final SNode target = SNodeOperations.cast(ListSequence.fromList(nodes).first(), CONCEPTS.InstanceMethodDeclaration$39);

    final SNode whereToMove = MoveNodeDialog.getSelectedObject(project, target, new MoveNodeDialog.NodeFilter("Select a Service/Repository to move the method to: refactoring can't be applied to the selected node.") {
      @Override
      public boolean check(SNode selectedObject, SNode nodeToMove, SModel modelOfSelectedNode) {
        if (SNodeOperations.isInstanceOf(nodeToMove, CONCEPTS.ServiceInstanceMethodDeclaration$ww)) {
          return SNodeOperations.isInstanceOf(selectedObject, CONCEPTS.Service$HK) && !(ListSequence.fromList(SNodeOperations.getNodeAncestors(nodeToMove, null, false)).contains(selectedObject));

        } else if (SNodeOperations.isInstanceOf(nodeToMove, CONCEPTS.RepositoryInstanceMethodDeclaration$Xh)) {
          return SNodeOperations.isInstanceOf(selectedObject, CONCEPTS.Repository$WM) && !(ListSequence.fromList(SNodeOperations.getNodeAncestors(nodeToMove, null, false)).contains(selectedObject));
        }
        return false;
      }
    });
    if (whereToMove == null) {
      return;
    }

    // actually do the move..
    MoveNodesUtil.moveTo(project, getName(), MapSequence.fromMapAndEntryArray(new HashMap<MoveNodesUtil.NodeProcessor, List<SNode>>(), Map.entry(new MoveNodesUtil.NodeCreatingProcessor(new ORIGMPS_MoveStaticField.NodeLocationClassifierMember(SNodeOperations.cast(whereToMove, CONCEPTS.ClassConcept$bK)), project) {
      @Override
      public List<SNode> getNodesToSearch(SNode nodeToMove) {
        return ListSequence.fromListAndArray(new ArrayList<SNode>(), nodeToMove);
      }

      @Override
      public void process(List<SNode> nodesRootsToMove, Map<SNode, RefactoringParticipant.KeepOldNodes> ifKeepOldNodes, RefactoringSession refactoringSession) {

        NodeCopyTracker copyMap = NodeCopyTracker.get(refactoringSession);
        copyMap.copyAndTrack(nodesRootsToMove);
        Map<SNode, SNode> oldMethodLocation = MapSequence.fromMap(new HashMap<SNode, SNode>());
        for (SNode oldNode : ListSequence.fromList(nodesRootsToMove)) {
          MapSequence.fromMap(oldMethodLocation).put(oldNode, SNodeOperations.getNodeAncestor(oldNode, CONCEPTS.ClassConcept$bK, false, false));
        }

        for (SNode oldNode : ListSequence.fromList(nodesRootsToMove)) {
          SNode newNode = MapSequence.fromMap(copyMap.getCopyMap()).get(oldNode);
          if (!(SNodeOperations.isInstanceOf(newNode, CONCEPTS.ServiceInstanceMethodDeclaration$ww) || SNodeOperations.isInstanceOf(newNode, CONCEPTS.RepositoryInstanceMethodDeclaration$Xh))) {
            throw new IllegalStateException();
          }

          SNode originalComponent = MapSequence.fromMap(oldMethodLocation).get(oldNode);

          MowareChanger c = new MowareChanger();
          c.searchForMethodUsage(myProject, oldNode);


          if (MapSequence.fromMap(ifKeepOldNodes).get(oldNode) == RefactoringParticipant.KeepOldNodes.REMOVE) {
            SNodeOperations.deleteNode(oldNode);
          }
          myNodeLocation.insertNode(myProject.getRepository(), newNode);

          MowareChanger.l("MoveServiceRepoMethod(): moved from " + SNodeOperations.present(originalComponent) + " -> " + SNodeOperations.getParent(newNode));
          c.changeMethodCalls(newNode);

        }
      }
    }, ListSequence.fromListAndArray(new ArrayList<SNode>(), target))));


  }

  private static final class CONCEPTS {
    /*package*/ static final SConcept ServiceInstanceMethodDeclaration$ww = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x6de6af0ef2406677L, "org.modellwerkstatt.objectflow.structure.ServiceInstanceMethodDeclaration");
    /*package*/ static final SConcept RepositoryInstanceMethodDeclaration$Xh = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x3d5d71b314aa1114L, "org.modellwerkstatt.manmap.structure.RepositoryInstanceMethodDeclaration");
    /*package*/ static final SConcept InstanceMethodDeclaration$39 = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc56b21dL, "jetbrains.mps.baseLanguage.structure.InstanceMethodDeclaration");
    /*package*/ static final SConcept Service$HK = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3eafb777941be31fL, "org.modellwerkstatt.objectflow.structure.Service");
    /*package*/ static final SConcept Repository$WM = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x3d5d71b314aa1113L, "org.modellwerkstatt.manmap.structure.Repository");
    /*package*/ static final SConcept ClassConcept$bK = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8c108ca66L, "jetbrains.mps.baseLanguage.structure.ClassConcept");
  }
}
