package org.modellwerkstatt.objectflow.util;

/*Generated by MPS */

import org.jetbrains.mps.openapi.model.SNode;
import org.jetbrains.mps.openapi.model.SModel;
import jetbrains.mps.smodel.action.SNodeFactoryOperations;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import org.modellwerkstatt.manmap.conventions.ImpExpNameHelper;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SModelOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import org.jetbrains.mps.openapi.language.SConcept;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import org.jetbrains.mps.openapi.language.SContainmentLink;
import org.jetbrains.mps.openapi.language.SReferenceLink;
import org.jetbrains.mps.openapi.language.SProperty;

public class CreateDefaultNoKeyMappingForManMap {
  private static final String SELECT = "SELECT ";
  private static final String FROM = " FROM ";
  private static final String AS = " AS ";


  public static String nextWord(String s) {
    String w = "";

    int i = 0;
    while (i < s.length() && s.charAt(i) != ' ' && s.charAt(i) != '\n') {
      w += s.charAt(i++);
    }

    w = w.trim();
    if (w.equals("")) {
      return null;
    }
    return w;
  }

  public static String removeQuotationsTrim(String s) {
    if (s == null) {
      return s;
    }
    return s.replace("\"", "").replace("'", "").trim();
  }

  public static SNode createAndAddViewObjectFromSql(SModel m, String viewObjectName, String[] sqlFields) {

    SNode vo = SNodeFactoryOperations.createNewRootNode(m, CONCEPTS.DTO$UE, null);
    ListSequence.fromList(SLinkOperations.getChildren(vo, LINKS.businessProperties$cI4J)).clear();


    // ok, built view...
    SPropertyOperations.assign(vo, PROPS.name$MnvL, ImpExpNameHelper.dbIdToJavaId(viewObjectName, true));
    for (String fldName : sqlFields) {
      SNode bp = SNodeFactoryOperations.addNewChild(vo, LINKS.businessProperties$cI4J, CONCEPTS.BusinessProperty$U);
      SPropertyOperations.assign(bp, PROPS.propertyName$DLW4, ImpExpNameHelper.dbIdToJavaId(fldName.replace(".", ""), false));

    }


    return vo;
  }

  public static SNode createAndAddViewObjectFromSql(SNode repo, SNode vo, String[] sqlFields) {
    SNode nkmap = SNodeFactoryOperations.addNewChild(repo, LINKS.member$L_2d, CONCEPTS.NoKeyMapperField$_P);

    SLinkOperations.setTarget(nkmap, LINKS.classConcept$G7ah, vo);
    SPropertyOperations.assign(nkmap, PROPS.name$MnvL, "mapper" + SPropertyOperations.getString(vo, PROPS.name$MnvL));

    for (int i = 0; i < sqlFields.length; i++) {
      SNode fld = SNodeFactoryOperations.addNewChild(nkmap, LINKS.atomMpig$bBsC, CONCEPTS.FieldMapping$r8);
      SLinkOperations.setTarget(fld, LINKS.property$JxuR, ListSequence.fromList(SLinkOperations.getChildren(vo, LINKS.businessProperties$cI4J)).getElement(i));
      SPropertyOperations.assign(SLinkOperations.getTarget(fld, LINKS.fieldName$un98), PROPS.value$w7MM, sqlFields[i]);

    }

    return nkmap;
  }

  public static String[] isoltateFields(String s) {
    int start = s.toUpperCase().indexOf(SELECT);
    int end = s.toUpperCase().indexOf(FROM);

    if (start < 0 || end < 0 || end <= start) {
      return null;
    }

    String middlePart = s.substring(start + SELECT.length(), end);

    String[] fields = middlePart.split(",");
    for (int i = 0; i < fields.length; i++) {
      String fld = fields[i].trim();

      int asIndex = fld.toUpperCase().indexOf(AS);

      // not first char, 'a b' is valid...
      int firstSpaceIndex = fld.indexOf(" ");
      if (firstSpaceIndex > 0 && asIndex < 0) {
        fld = fld.replaceFirst(" ", " " + AS + " ");
      }

      asIndex = fld.toUpperCase().indexOf(AS);
      if (asIndex >= 0) {
        fld = fld.substring(asIndex + AS.length());
      }

      fields[i] = removeQuotationsTrim(fld);
    }

    return fields;
  }
  public static String isoltateViewObjectName(String s) {
    int i = s.toUpperCase().indexOf(FROM);
    if (i < 0) {
      return null;
    }

    String tableName = nextWord(s.substring(i + FROM.length()));
    return removeQuotationsTrim(tableName);

  }


  public static String printArray(String[] arr) {
    if (arr == null) {
      return "null";
    }

    String s = "[";
    for (String a : arr) {
      s += a + ", ";
    }
    s += "]";
    return s;
  }

  public static SNode getOrCreateTestSuitForRepo(final SNode repo) {

    SNode ts = ListSequence.fromList(SModelOperations.roots(SNodeOperations.getModel(repo), CONCEPTS.OFXTestSuit$Iy)).findFirst((it) -> SPropertyOperations.getString(it, PROPS.name$MnvL).equals("Test" + SPropertyOperations.getString(repo, PROPS.name$MnvL)));
    if ((ts == null)) {
      ts = SNodeFactoryOperations.createNewRootNode(SNodeOperations.getModel(repo), CONCEPTS.OFXTestSuit$Iy, null);
      SPropertyOperations.assign(ts, PROPS.name$MnvL, "Test" + SPropertyOperations.getString(repo, PROPS.name$MnvL));

    }

    return ts;
  }

  public static SNode createTestMethodFor(SNode ts, SNode repoMethod) {
    SNode tm = SNodeFactoryOperations.addNewChild(ts, LINKS.content$_1km, CONCEPTS.OFXTestMethod$cv);
    SPropertyOperations.assign(tm, PROPS.name$MnvL, "testFor_" + SPropertyOperations.getString(repoMethod, PROPS.name$MnvL));
    SNodeFactoryOperations.setNewChild(tm, LINKS.returnType$5xoi, CONCEPTS.VoidType$BF);

    SNode lvds = SNodeFactoryOperations.setNewChild(SNodeFactoryOperations.addNewChild(SLinkOperations.getTarget(tm, LINKS.body$5xQk), LINKS.statement$53DE, CONCEPTS.LocalVariableDeclarationStatement$4w), LINKS.localVariableDeclaration$RpjM, CONCEPTS.LocalVariableDeclaration$41);
    SLinkOperations.setTarget(lvds, LINKS.type$a1UY, SNodeOperations.copyNode(SLinkOperations.getTarget(repoMethod, LINKS.returnType$5xoi)));
    SPropertyOperations.assign(lvds, PROPS.name$MnvL, "result");
    SNode oc = SNodeFactoryOperations.setNewChild(lvds, LINKS.initializer$2twD, CONCEPTS.OperationCall$7H);
    SLinkOperations.setTarget(oc, LINKS.runtimeHandledObject$2jLr, SNodeOperations.getNodeAncestor(repoMethod, CONCEPTS.Repository$WM, false, false));
    SLinkOperations.setTarget(oc, LINKS.baseMethodDeclaration$pyYw, repoMethod);

    SNode as = SNodeFactoryOperations.addNewChild(SLinkOperations.getTarget(tm, LINKS.body$5xQk), LINKS.statement$53DE, CONCEPTS.AssertStatement$CT);
    SNode gee = SNodeFactoryOperations.setNewChild(as, LINKS.condition$ccjq, CONCEPTS.GreaterThanOrEqualsExpression$NV);

    SPropertyOperations.assign(SNodeFactoryOperations.setNewChild(gee, LINKS.rightExpression$nvX, CONCEPTS.IntegerConstant$Na), PROPS.value$jgCM, 2);
    SNode dot = SNodeFactoryOperations.setNewChild(gee, LINKS.leftExpression$sEj, CONCEPTS.DotExpression$yW);
    SLinkOperations.setTarget(SNodeFactoryOperations.setNewChild(dot, LINKS.operand$w6IR, CONCEPTS.VariableReference$TC), LINKS.variableDeclaration$N1XG, lvds);
    SNodeFactoryOperations.setNewChild(dot, LINKS.operation$gs9E, CONCEPTS.GetSizeOperation$A_);

    return tm;
  }



  public static void main(String[] args) {

    System.err.println(isoltateViewObjectName("SELECT HELLO, WORLD FROM XYZ as  JOIN XXSSLL "));
    System.err.println(isoltateViewObjectName("SELECTHELLO WORLD FROMXYZ as  JOIN XXSSLL "));
    System.err.println(isoltateViewObjectName("SELECT HELLO WORLD FROM \"XYZ\""));


    System.err.println(printArray(isoltateFields("SELECT HELLO,WORLD FROM XYZ as  JOIN XXSSLL ")));
    System.err.println(printArray(isoltateFields("SELECTHELLO,WORLD FROMXYZ as  JOIN XXSSLL ")));
    System.err.println(printArray(isoltateFields("SELECT HELLO, WORLD, DAN, col as \"pete\", col as franz FROM \"XYZ\"")));

  }

  private static final class CONCEPTS {
    /*package*/ static final SConcept DTO$UE = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x488302ba36b9283fL, "org.modellwerkstatt.objectflow.structure.DTO");
    /*package*/ static final SConcept BusinessProperty$U = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x7485cdb73f561ff9L, "org.modellwerkstatt.objectflow.structure.BusinessProperty");
    /*package*/ static final SConcept NoKeyMapperField$_P = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xad9572552c31468L, "org.modellwerkstatt.manmap.structure.NoKeyMapperField");
    /*package*/ static final SConcept FieldMapping$r8 = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d063L, "org.modellwerkstatt.manmap.structure.FieldMapping");
    /*package*/ static final SConcept OFXTestSuit$Iy = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x128a6a0cae5ec4baL, "org.modellwerkstatt.objectflow.structure.OFXTestSuit");
    /*package*/ static final SConcept OFXTestMethod$cv = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x607becf482ad5e9fL, "org.modellwerkstatt.objectflow.structure.OFXTestMethod");
    /*package*/ static final SConcept VoidType$BF = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc6bf96dL, "jetbrains.mps.baseLanguage.structure.VoidType");
    /*package*/ static final SConcept LocalVariableDeclarationStatement$4w = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc67c7f0L, "jetbrains.mps.baseLanguage.structure.LocalVariableDeclarationStatement");
    /*package*/ static final SConcept LocalVariableDeclaration$41 = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc67c7efL, "jetbrains.mps.baseLanguage.structure.LocalVariableDeclaration");
    /*package*/ static final SConcept OperationCall$7H = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x6e0022916f60f59bL, "org.modellwerkstatt.objectflow.structure.OperationCall");
    /*package*/ static final SConcept Repository$WM = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0x3d5d71b314aa1113L, "org.modellwerkstatt.manmap.structure.Repository");
    /*package*/ static final SConcept AssertStatement$CT = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x10e50ecba3dL, "jetbrains.mps.baseLanguage.structure.AssertStatement");
    /*package*/ static final SConcept GreaterThanOrEqualsExpression$NV = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x10c8d0fac2cL, "jetbrains.mps.baseLanguage.structure.GreaterThanOrEqualsExpression");
    /*package*/ static final SConcept IntegerConstant$Na = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc59b314L, "jetbrains.mps.baseLanguage.structure.IntegerConstant");
    /*package*/ static final SConcept DotExpression$yW = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x116b46a08c4L, "jetbrains.mps.baseLanguage.structure.DotExpression");
    /*package*/ static final SConcept VariableReference$TC = MetaAdapterFactory.getConcept(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8c77f1e98L, "jetbrains.mps.baseLanguage.structure.VariableReference");
    /*package*/ static final SConcept GetSizeOperation$A_ = MetaAdapterFactory.getConcept(0x8388864671ce4f1cL, 0x9c53c54016f6ad4fL, 0x10ec4627e6fL, "jetbrains.mps.baseLanguage.collections.structure.GetSizeOperation");
  }

  private static final class LINKS {
    /*package*/ static final SContainmentLink businessProperties$cI4J = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3bdce9a978275e87L, 0x2c8253fb15073741L, "businessProperties");
    /*package*/ static final SContainmentLink member$L_2d = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x101d9d3ca30L, 0x4a9a46de59132803L, "member");
    /*package*/ static final SReferenceLink classConcept$G7ah = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xad9572552c31468L, 0xad9572552c31569L, "classConcept");
    /*package*/ static final SContainmentLink atomMpig$bBsC = MetaAdapterFactory.getContainmentLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e476b28L, 0x3f409dc3f36bdc67L, "atomMpig");
    /*package*/ static final SReferenceLink property$JxuR = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d063L, 0xc18788c4e476aafL, "property");
    /*package*/ static final SContainmentLink fieldName$un98 = MetaAdapterFactory.getContainmentLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d063L, 0xc18788c4e480de7L, "fieldName");
    /*package*/ static final SContainmentLink content$_1km = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x128a6a0cae5ec4baL, 0x607becf482b20095L, "content");
    /*package*/ static final SContainmentLink returnType$5xoi = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc56b1fcL, 0xf8cc56b1fdL, "returnType");
    /*package*/ static final SContainmentLink body$5xQk = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc56b1fcL, 0xf8cc56b1ffL, "body");
    /*package*/ static final SContainmentLink statement$53DE = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc56b200L, 0xf8cc6bf961L, "statement");
    /*package*/ static final SContainmentLink localVariableDeclaration$RpjM = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc67c7f0L, 0xf8cc67c7f1L, "localVariableDeclaration");
    /*package*/ static final SContainmentLink type$a1UY = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x450368d90ce15bc3L, 0x4ed4d318133c80ceL, "type");
    /*package*/ static final SContainmentLink initializer$2twD = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8c37a7f6eL, 0xf8c37f506eL, "initializer");
    /*package*/ static final SReferenceLink runtimeHandledObject$2jLr = MetaAdapterFactory.getReferenceLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x6e0022916f60f59bL, 0x6e0022916f60f5b4L, "runtimeHandledObject");
    /*package*/ static final SReferenceLink baseMethodDeclaration$pyYw = MetaAdapterFactory.getReferenceLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x11857355952L, 0xf8c78301adL, "baseMethodDeclaration");
    /*package*/ static final SContainmentLink condition$ccjq = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x10e50ecba3dL, 0x10e50ed44ceL, "condition");
    /*package*/ static final SContainmentLink rightExpression$nvX = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xfbdeb6fecfL, 0xfbdeb7a11bL, "rightExpression");
    /*package*/ static final SContainmentLink leftExpression$sEj = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xfbdeb6fecfL, 0xfbdeb7a11cL, "leftExpression");
    /*package*/ static final SContainmentLink operand$w6IR = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x116b46a08c4L, 0x116b46a4416L, "operand");
    /*package*/ static final SReferenceLink variableDeclaration$N1XG = MetaAdapterFactory.getReferenceLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8c77f1e98L, 0xf8cc6bf960L, "variableDeclaration");
    /*package*/ static final SContainmentLink operation$gs9E = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x116b46a08c4L, 0x116b46b36c4L, "operation");
  }

  private static final class PROPS {
    /*package*/ static final SProperty name$MnvL = MetaAdapterFactory.getProperty(0xceab519525ea4f22L, 0x9b92103b95ca8c0cL, 0x110396eaaa4L, 0x110396ec041L, "name");
    /*package*/ static final SProperty propertyName$DLW4 = MetaAdapterFactory.getProperty(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x117b744dafeL, 0x117b75204e4L, "propertyName");
    /*package*/ static final SProperty value$w7MM = MetaAdapterFactory.getProperty(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf93d565d10L, 0xf93d565d11L, "value");
    /*package*/ static final SProperty value$jgCM = MetaAdapterFactory.getProperty(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf8cc59b314L, 0xf8cc59b315L, "value");
  }
}
