package org.modellwerkstatt.objectflow.util;

/*Generated by MPS */

import org.jetbrains.mps.openapi.model.SNode;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SNodeOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SPropertyOperations;
import org.modellwerkstatt.manmap.conventions.ImpExpNameHelper;
import org.modellwerkstatt.objectflow.behavior.IOFXObject__BehaviorDescriptor;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SLinkOperations;
import jetbrains.mps.lang.smodel.generator.smodelAdapter.SConceptOperations;
import jetbrains.mps.smodel.adapter.structure.MetaAdapterFactory;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.smodel.builder.SNodeBuilder;
import org.jetbrains.mps.openapi.language.SConcept;
import org.jetbrains.mps.openapi.language.SProperty;
import org.jetbrains.mps.openapi.language.SContainmentLink;
import org.jetbrains.mps.openapi.language.SReferenceLink;

public class SQLDescTableParser {
  private String lineText;
  private int currentPosition;

  public SQLDescTableParser(String text) {
    this.lineText = ((text == null ? null : text.trim()));
    this.currentPosition = 0;

    // token exceptions here. quick n dirty
    lineText = lineText.replace(";", "\n");
    lineText = lineText.replace("\r", "\n");
    lineText = lineText.replace("\n\n", "\n");
    lineText = lineText.replace("\n\n\n", "\n");
    lineText = lineText.replace("NOT NULL", "NOT_NULL");
  }


  public void eatSpace(boolean withNewLine) {
    while (currentPosition < lineText.length() && (lineText.charAt(currentPosition) == ' ' || (withNewLine && lineText.charAt(currentPosition) == '\n'))) {
      currentPosition++;
    }
  }

  public Token nextToken() {
    Token newToken = new Token();

    eatSpace(true);

    // nothing left?
    if (currentPosition >= lineText.length()) {
      return null;
    }

    // read id
    for (int i = currentPosition; i < lineText.length(); i++, currentPosition++) {
      char curChar = lineText.charAt(i);

      if (curChar == ' ' || curChar == '\n' || curChar == '(') {
        break;
      }
      if (curChar == ')') {
        throw new RuntimeException("Missing the opening parenthesis '(' after processing \n\n" + lineText.substring(0, currentPosition));
      }
      newToken.id += curChar;
    }

    eatSpace(false);


    if (currentPosition < lineText.length() && lineText.charAt(currentPosition) == '(') {
      newToken.hasParentInfo = true;
      currentPosition++;

      // parse paren info
      for (int i = currentPosition; i < lineText.length(); i++, currentPosition++) {
        char curChar = lineText.charAt(i);

        if (curChar == ')' || curChar == '\n') {
          break;
        }
        newToken.parenthesisInfo += curChar;
      }

      if (lineText.charAt(currentPosition) != ')') {
        throw new RuntimeException("Missing the closing parenthesis ')' after processing \n\n" + lineText.substring(0, currentPosition));
      }
      currentPosition++;
    }

    // check token
    if ("".equals(newToken.id)) {
      throw new RuntimeException("Token id equals empty string after processing \n\n" + lineText.substring(0, currentPosition));
    }

    return newToken;
  }


  public SNode getTypeFor(String typeString) {
    boolean decimalSuspicious = false;
    if (typeString.indexOf("(") >= 0) {
      if (typeString.indexOf(",") > typeString.indexOf("(")) {
        decimalSuspicious = true;
      }
      typeString = typeString.substring(0, typeString.indexOf("("));
    }
    typeString = typeString.toLowerCase().trim();
    // default ??
    return null;
  }





  public void parse(SNode theObject, SNode mapping) {
    // description has to start with desc keyword
    Token tok = nextToken();

    if (tok == null || !(tok.id.toLowerCase().equals("desc"))) {
      throw new RuntimeException("Given description does not start with 'desc' keyWord followed by table name.");
    }

    tok = nextToken();
    if (tok == null) {
      throw new RuntimeException("Given description does not start with 'desc' keyWord followed by table name. Table name missing");
    }

    System.out.println("Table Name: " + tok.id);

    if (SNodeOperations.isInstanceOf(mapping, CONCEPTS.EntityMapping$ux)) {
      SNode em = SNodeOperations.cast(mapping, CONCEPTS.EntityMapping$ux);
      SPropertyOperations.assign(SNodeOperations.cast(theObject, CONCEPTS.Entity$WP), PROPS.name$MnvL, ImpExpNameHelper.dbIdToJavaId(tok.id, true));

      SPropertyOperations.assign(em, PROPS.name$MnvL, "Map" + IOFXObject__BehaviorDescriptor.getName_id2vvVhmoLArJ.invoke(theObject));
      SLinkOperations.setTarget(em, LINKS.tableName$PpjQ, _quotation_createNode_qg6e6v_a0e0k0r());
      SPropertyOperations.assign(SLinkOperations.getTarget(em, LINKS.tableName$PpjQ), PROPS.value$w7MM, tok.id);
      SLinkOperations.setTarget(em, LINKS.classConcept$r5Kr, SNodeOperations.cast(theObject, CONCEPTS.Entity$WP));

    } else if (SNodeOperations.isInstanceOf(mapping, CONCEPTS.NoKeyMapperField$_P)) {
      SNode nkmf = SNodeOperations.cast(mapping, CONCEPTS.NoKeyMapperField$_P);
      SPropertyOperations.assign(SNodeOperations.cast(theObject, CONCEPTS.DTO$UE), PROPS.name$MnvL, ImpExpNameHelper.dbIdToJavaId(tok.id, true));

      SPropertyOperations.assign(nkmf, PROPS.name$MnvL, "map" + IOFXObject__BehaviorDescriptor.getName_id2vvVhmoLArJ.invoke(theObject));
      SLinkOperations.setTarget(nkmf, LINKS.classConcept$G7ah, SNodeOperations.cast(theObject, CONCEPTS.DTO$UE));

    }


    // Name Null? Type - table headings
    tok = nextToken();
    tok = nextToken();
    tok = nextToken();

    // Some trailing lines
    tok = nextToken();
    tok = nextToken();
    tok = nextToken();

    //  okay, now the fields...



    // seek for start of table description
    tok = nextToken();
    while (tok != null) {

      String fieldName = tok.id;

      if (tok.hasParentInfo) {
        throw new RuntimeException("Parenthesis info given for field name? Not parsable " + tok.id + " / " + tok.parenthesisInfo);
      }
      System.err.println("Field Name: " + tok.id);

      tok = nextToken();
      if ("NOT_NULL".equals(tok.id)) {
        tok = nextToken();
        System.err.println("       NOT_NULL given");
      }
      // now we have to check the type
      if (tok == null) {
        throw new RuntimeException("Unexpected end of description, expecting a type for field " + fieldName);
      }

      SNode newProp = SConceptOperations.createNewNode(MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x7485cdb73f561ff9L, "org.modellwerkstatt.objectflow.structure.BusinessProperty"));
      SPropertyOperations.assign(newProp, PROPS.propertyName$DLW4, ImpExpNameHelper.dbIdToJavaId(fieldName, false));
      ListSequence.fromList(SLinkOperations.getChildren(theObject, LINKS.businessProperties$cI4J)).addElement(newProp);

      String type = tok.id.toLowerCase();
      if (type.equals("varchar2") || type.equals("varchar")) {
        SLinkOperations.setTarget(newProp, LINKS.type$56v0, _quotation_createNode_qg6e6v_a0a0q0db0r());

      } else if (type.equals("date")) {
        SLinkOperations.setTarget(newProp, LINKS.type$56v0, _quotation_createNode_qg6e6v_a0a0a61a92a71());

      } else if (type.equals("number")) {
        if (!(tok.hasParentInfo)) {
          throw new RuntimeException("After a number type in field " + fieldName + " a field size is expected in parenthesis.");
        }
        String fieldLenght = tok.parenthesisInfo.replace(".", ",");
        if (fieldLenght.contains(",")) {
          SLinkOperations.setTarget(newProp, LINKS.type$56v0, _quotation_createNode_qg6e6v_a0a0c0b61a92a71());
          String[] deciInfo = fieldLenght.split(",");
          SNode so = SConceptOperations.createNewNode(MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xabe89ec1935f3e3L, "org.modellwerkstatt.manmap.structure.SizeOption"));

          SPropertyOperations.assign(so, PROPS.value$hAZI, new Integer(deciInfo[0]));
          SPropertyOperations.assign(so, PROPS.decvalue$hBeJ, new Integer(deciInfo[1]));
          ListSequence.fromList(SLinkOperations.getChildren(newProp, LINKS.propertyOption$7dlM)).addElement(so);

        } else {
          SLinkOperations.setTarget(newProp, LINKS.type$56v0, _quotation_createNode_qg6e6v_a0a0a2a1q0db0r());
        }

      } else {
        throw new RuntimeException("Unknown type in description text: " + type);
      }

      SNode fm = SConceptOperations.createNewNode(MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d063L, "org.modellwerkstatt.manmap.structure.FieldMapping"));
      SLinkOperations.setTarget(fm, LINKS.property$JxuR, newProp);
      SLinkOperations.setTarget(fm, LINKS.fieldName$un98, _quotation_createNode_qg6e6v_a0u0db0r());
      SPropertyOperations.assign(SLinkOperations.getTarget(fm, LINKS.fieldName$un98), PROPS.value$w7MM, fieldName);
      ListSequence.fromList(SLinkOperations.getChildren(mapping, LINKS.atomMpig$bBsC)).addElement(fm);

      tok = nextToken();
    }
  }

  public static class Token {
    public Token() {
      id = "";
      parenthesisInfo = "";
      hasParentInfo = false;
    }

    public String id;
    public String parenthesisInfo;
    public boolean hasParentInfo;

  }
  private static SNode _quotation_createNode_qg6e6v_a0e0k0r() {
    SNode quotedNode_1 = null;
    SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept(MetaAdapterFactory.getLanguage(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, "jetbrains.mps.baseLanguage"), 0xf93d565d10L, "StringLiteral"));
    quotedNode_1 = nb.getResult();
    return quotedNode_1;
  }
  private static SNode _quotation_createNode_qg6e6v_a0a0q0db0r() {
    SNode quotedNode_1 = null;
    SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept(MetaAdapterFactory.getLanguage(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, "jetbrains.mps.baseLanguage"), 0x11d47da71ecL, "StringType"));
    quotedNode_1 = nb.getResult();
    return quotedNode_1;
  }
  private static SNode _quotation_createNode_qg6e6v_a0a0a61a92a71() {
    SNode quotedNode_1 = null;
    SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept(MetaAdapterFactory.getLanguage(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, "jetbrains.mps.baseLanguage"), 0x101de48bf9eL, "ClassifierType"));
    quotedNode_1 = nb.getResult();
    nb.setReference(MetaAdapterFactory.getReferenceLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x101de48bf9eL, 0x101de490babL, "classifier"), "37fdf88a-1025-4d01-864a-0bf987f72e6f/java:org.joda.time(org.modellwerkstatt.manmap.runtime/)/~DateTime");
    return quotedNode_1;
  }
  private static SNode _quotation_createNode_qg6e6v_a0a0c0b61a92a71() {
    SNode quotedNode_1 = null;
    SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept(MetaAdapterFactory.getLanguage(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, "jetbrains.mps.baseLanguage"), 0x101de48bf9eL, "ClassifierType"));
    quotedNode_1 = nb.getResult();
    nb.setReference(MetaAdapterFactory.getReferenceLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x101de48bf9eL, 0x101de490babL, "classifier"), "6354ebe7-c22a-4a0f-ac54-50b52ab9b065/java:java.math(JDK/)/~BigDecimal");
    return quotedNode_1;
  }
  private static SNode _quotation_createNode_qg6e6v_a0a0a2a1q0db0r() {
    SNode quotedNode_1 = null;
    SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept(MetaAdapterFactory.getLanguage(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, "jetbrains.mps.baseLanguage"), 0xf940d22479L, "IntegerType"));
    quotedNode_1 = nb.getResult();
    return quotedNode_1;
  }
  private static SNode _quotation_createNode_qg6e6v_a0u0db0r() {
    SNode quotedNode_1 = null;
    SNodeBuilder nb = new SNodeBuilder(null, null).init(MetaAdapterFactory.getConcept(MetaAdapterFactory.getLanguage(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, "jetbrains.mps.baseLanguage"), 0xf93d565d10L, "StringLiteral"));
    quotedNode_1 = nb.getResult();
    return quotedNode_1;
  }

  private static final class CONCEPTS {
    /*package*/ static final SConcept EntityMapping$ux = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d06aL, "org.modellwerkstatt.manmap.structure.EntityMapping");
    /*package*/ static final SConcept Entity$WP = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x130a62a9d793b6e4L, "org.modellwerkstatt.objectflow.structure.Entity");
    /*package*/ static final SConcept NoKeyMapperField$_P = MetaAdapterFactory.getConcept(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xad9572552c31468L, "org.modellwerkstatt.manmap.structure.NoKeyMapperField");
    /*package*/ static final SConcept DTO$UE = MetaAdapterFactory.getConcept(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x488302ba36b9283fL, "org.modellwerkstatt.objectflow.structure.DTO");
  }

  private static final class PROPS {
    /*package*/ static final SProperty name$MnvL = MetaAdapterFactory.getProperty(0xceab519525ea4f22L, 0x9b92103b95ca8c0cL, 0x110396eaaa4L, 0x110396ec041L, "name");
    /*package*/ static final SProperty value$w7MM = MetaAdapterFactory.getProperty(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0xf93d565d10L, 0xf93d565d11L, "value");
    /*package*/ static final SProperty propertyName$DLW4 = MetaAdapterFactory.getProperty(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x117b744dafeL, 0x117b75204e4L, "propertyName");
    /*package*/ static final SProperty value$hAZI = MetaAdapterFactory.getProperty(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xabe89ec1935f3e3L, 0xabe89ec1935f3e4L, "value");
    /*package*/ static final SProperty decvalue$hBeJ = MetaAdapterFactory.getProperty(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xabe89ec1935f3e3L, 0xabe89ec1935f3e5L, "decvalue");
  }

  private static final class LINKS {
    /*package*/ static final SContainmentLink tableName$PpjQ = MetaAdapterFactory.getContainmentLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d06aL, 0xc18788c4e5a1501L, "tableName");
    /*package*/ static final SReferenceLink classConcept$r5Kr = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d06aL, 0xc18788c4e4730efL, "classConcept");
    /*package*/ static final SReferenceLink classConcept$G7ah = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xad9572552c31468L, 0xad9572552c31569L, "classConcept");
    /*package*/ static final SContainmentLink businessProperties$cI4J = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x3bdce9a978275e87L, 0x2c8253fb15073741L, "businessProperties");
    /*package*/ static final SContainmentLink type$56v0 = MetaAdapterFactory.getContainmentLink(0xf3061a5392264cc5L, 0xa443f952ceaf5816L, 0x117b744dafeL, 0x117b752a0b9L, "type");
    /*package*/ static final SContainmentLink propertyOption$7dlM = MetaAdapterFactory.getContainmentLink(0xec097fca5b8441f2L, 0x847d6a5690cae277L, 0x7485cdb73f561ff9L, 0x32fe6ed1329fd49bL, "propertyOption");
    /*package*/ static final SReferenceLink property$JxuR = MetaAdapterFactory.getReferenceLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d063L, 0xc18788c4e476aafL, "property");
    /*package*/ static final SContainmentLink fieldName$un98 = MetaAdapterFactory.getContainmentLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e46d063L, 0xc18788c4e480de7L, "fieldName");
    /*package*/ static final SContainmentLink atomMpig$bBsC = MetaAdapterFactory.getContainmentLink(0x5aaa957f34474783L, 0xb1f7b301fa3e0394L, 0xc18788c4e476b28L, 0x3f409dc3f36bdc67L, "atomMpig");
  }
}
