package org.modellwerkstatt.fx8forms.delegates;

/*Generated by MPS */

import javafx.scene.control.TextField;
import javafx.stage.Popup;
import javafx.scene.control.ListView;
import java.util.List;
import org.modellwerkstatt.dataux.runtime.extensions.IDataUxDelegate;
import javafx.geometry.Orientation;
import javafx.scene.input.KeyEvent;
import javafx.event.EventHandler;
import javafx.scene.input.KeyCode;
import org.modellwerkstatt.fx8forms.windows.FX8Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.input.MouseEvent;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import org.modellwerkstatt.dataux.runtime.delegates.ReferenceDelegate;
import org.modellwerkstatt.objectflow.runtime.SaveObjectComperator;
import org.modellwerkstatt.fx8forms.windows.FX8TraversalHelper;
import javafx.geometry.Bounds;

public class AutoCompletePopupField extends TextField {
  private Popup popup = new Popup();
  private ListView<String> listView = new ListView<String>();
  private List<String> items;
  private boolean textChangeListenerEnabled;
  private IDataUxDelegate delegate;
  private boolean issueBoundEvent;
  private boolean optionalAlso;

  protected boolean issueUpdateConclusion;
  protected String lastItemIssuedUpdate;
  protected boolean provideHintEnabled = false;
  protected String provideHintLast = "";

  public AutoCompletePopupField() {
    super();
    issueUpdateConclusion = false;
    lastItemIssuedUpdate = null;

    textChangeListenerEnabled = true;
    issueBoundEvent = false;
    optionalAlso = false;

    listView.setPrefWidth(450);
    listView.setPrefHeight(170);
    listView.setOrientation(Orientation.VERTICAL);
    popup.getContent().add(listView);

    popup.addEventFilter(KeyEvent.ANY, new EventHandler<KeyEvent>() {
      @Override
      public void handle(KeyEvent keyEvent) {
        boolean checkIssueUpdateOrTraverse = false;

        if (keyEvent.getCode().equals(KeyCode.ESCAPE)) {
          keyEvent.consume();
          if (keyEvent.getEventType().equals(KeyEvent.KEY_RELEASED)) {
            popup.hide();
          }
        } else if ((keyEvent.getCode().equals(KeyCode.ENTER) || keyEvent.getCode().equals(KeyCode.TAB)) && keyEvent.getEventType().equals(KeyEvent.KEY_RELEASED)) {

          ll("popup.EventListener", "ENTER");
          // KeyHandler for Enter on DelegateForm does not work when context menu is open
          // This event is consumed, in case any action for menu selection was triggered.
          // so if we receive it, simply move on with the focus ...
          boolean found = showCompletionAndBindIfPossible(false, true, listView.getSelectionModel().getSelectedItem());

          if (provideHintEnabled && !(found)) {
            provideHint();

          } else if (!(popup.isShowing())) {
            keyEvent.consume();
            traverseOrIssueUpdateConc();
          }
        }
      }
    });

    this.addEventFilter(KeyEvent.ANY, new EventHandler<KeyEvent>() {
      @Override
      public void handle(KeyEvent keyEvent) {

        if (keyEvent.getCode() == KeyCode.TAB && keyEvent.getEventType().equals(KeyEvent.KEY_PRESSED) && !(keyEvent.isShiftDown())) {
          showCompletionAndBindIfPossible(false, true, null);

          if (!(popup.isShowing())) {
            keyEvent.consume();
            traverseOrIssueUpdateConc();
          }

        } else if (keyEvent.getCode() == KeyCode.ENTER && keyEvent.getEventType().equals(KeyEvent.KEY_PRESSED)) {
          ll("Text Key ", "ENTER " + getItem());

          showCompletionAndBindIfPossible(false, true, null);

          if (!(popup.isShowing())) {
            keyEvent.consume();
            traverseOrIssueUpdateConc();
          }

        } else if (keyEvent.getCode() == KeyCode.SPACE && keyEvent.getEventType().equals(KeyEvent.KEY_PRESSED) && keyEvent.isControlDown()) {

          ll("keyEventFilter.ANY", "crtl space pressed.");
          // CRTL - SPACE hit
          keyEvent.consume();
          boolean found = showCompletionAndBindIfPossible(true, false, null);


          // always trigger a search?
          if (provideHintEnabled) {
            if (specificItemSelected()) {
              setText(provideHintLast);
            }

            provideHint();
          }


        } else if (keyEvent.getCode() == KeyCode.A && keyEvent.getEventType().equals(KeyEvent.KEY_PRESSED) && (keyEvent.isControlDown() || keyEvent.isMetaDown())) {
          AutoCompletePopupField.this.selectAll();

        } else if (FX8Application.FX8_IS_HOTKEY_TO_FORWARD(keyEvent.getCode().getName(), false) && AutoCompletePopupField.this.getScene() != null) {
          AutoCompletePopupField.this.getScene().getOnKeyPressed().handle(keyEvent);


        }

      }
    });


    this.textProperty().addListener(new ChangeListener<String>() {
      @Override
      public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
        if (textChangeListenerEnabled) {
          // Bug ? do not showCompletion if not already displayed on screen...
          if (newValue.length() == 0) {
            popup.hide();

          } else {
            showCompletionAndBindIfPossible(false, false, null);
          }
        }
      }
    });

    this.focusedProperty().addListener(new ChangeListener<Boolean>() {
      @Override
      public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
        ll("this.focusProperty", "focus changed to " + newValue);
        if (newValue == false) {
          // loosing focus ...
          // try to bind
          showCompletionAndBindIfPossible(false, true, null);
          // close menu anyway
          if (popup.isShowing()) {
            popup.hide();
          }
          // check if entry can be bind to list ??
          checkDelegateIsInputValid();
        }
      }
    });

    //  handle item selection
    listView.getSelectionModel().selectedItemProperty().addListener(new ChangeListener<Object>() {
      public void changed(ObservableValue<? extends Object> value, Object oldValue, Object newValue) {
        ll("listView.getSelectedModel()", "from '" + oldValue + "' to '" + newValue + "'");
        if (newValue == null || oldValue == null) {
          ll("listView.getSelectedModel()", "SKIPPED setting item to " + newValue);
          // nothing selected
        } else {
          AutoCompletePopupField.this.setItem((String) newValue);
        }
      }
    });

    listView.setOnMouseClicked(new EventHandler<MouseEvent>() {
      public void handle(MouseEvent p0) {
        ll("listView.setOnMouseClick()", "calling setItem() next.. ");

        setItem(((String) listView.getSelectionModel().getSelectedItem()));
        // Introduced with MRS Plugin, after reported bug
        popup.hide();
        traverseOrIssueUpdateConc();
      }
    });

    this.setOnMouseClicked(new EventHandler<MouseEvent>() {
      public void handle(MouseEvent p0) {
        ll("this.setOnMouseClick", "" + p0);

        showCompletionAndBindIfPossible(true, false, null);
      }
    });



    this.items = ListSequence.fromList(new ArrayList<String>());
  }


  protected void provideHint() {
    String textHint = getText();
    provideHintLast = textHint;

    ll("provideHint", " issuing a hint updated for <" + textHint + ">");
    ((ReferenceDelegate) delegate).setHintForScope(textHint);

    lastItemIssuedUpdate = null;
    delegate.issueUpdateConclusionAfterContentChange();
    setText(textHint);

    ll("provideHint", "HINT UPDATE DONE");
  }

  private void traverseOrIssueUpdateConc() {
    String item = getItem();
    boolean sameItem = SaveObjectComperator.equals(item, lastItemIssuedUpdate);

    ll("traverseOrIssueUpdateConc", " with item " + item + " is same " + sameItem);

    if (isIssueUpdate() && !(sameItem)) {
      if (delegate.isInputValid() == null && !(this.isDisabled())) {
        lastItemIssuedUpdate = item;
        delegate.issueUpdateConclusionAfterContentChange();
      }

    } else {
      FX8TraversalHelper.traverseNext(AutoCompletePopupField.this);

    }

  }
  public void newObjectBound() {
    lastItemIssuedUpdate = null;
  }
  public void setDelegate(IDataUxDelegate dlgt) {
    delegate = dlgt;
  }
  public void checkDelegateIsInputValid() {
    if (delegate != null) {
      delegate.isInputValid();
    }
  }

  private void populateMenu(List<String> items) {
    ll("populateMenu", "");
    listView.getItems().clear();
    for (String result : items) {
      listView.getItems().add(result);
    }
    if (listView.getItems().size() > 0) {
      // new behaviour in java 11
      listView.getSelectionModel().select(0);
    }

    if (!(popup.isShowing()) && this.getScene() != null) {
      Bounds pos = this.localToScreen(this.getBoundsInLocal());
      popup.show(this.getScene().getWindow(), pos.getMinX(), pos.getMaxY());

    }
    popup.requestFocus();
  }
  public void setItems(List<String> items) {
    this.items = items;
  }

  private boolean specificItemSelected() {
    for (int i = 0; i < this.items.size(); i++) {
      if (this.getText().toLowerCase().equals(items.get(i).toLowerCase())) {
        return true;
      }
    }
    return false;
  }
  public String getItem() {
    for (int i = 0; i < this.items.size(); i++) {
      if (this.getText().toLowerCase().equals(items.get(i).toLowerCase())) {
        return items.get(i);
      }
    }
    // clear text at least
    ll("getItem", "clearing text");
    this.setText("");
    return null;
  }
  public void setItem(String item) {
    ll("setItem", "setting item to " + item);
    textChangeListenerEnabled = false;
    boolean found = false;

    if (item == null) {
      this.setText("");

    } else {
      // check again
      for (int i = 0; i < this.items.size(); i++) {
        if (item.toLowerCase().equals(items.get(i).toLowerCase())) {
          this.setText(items.get(i));
          this.selectAll();
          checkDelegateIsInputValid();
          found = true;
          break;
        }
      }

      if (!(found) && this.items.size() > 0) {
        String error = "'" + item + "' not in reference scope (len " + this.items.size() + "). programming error.";
        this.setText(error);
        throw new RuntimeException(error);

      } else if (!(found)) {
        // accept text ??? no scope given ... hopefully in disabled mode : )
        this.setText(item);
        this.selectAll();
        checkDelegateIsInputValid();
      }


    }

    if (issueBoundEvent && (found || (item == null && optionalAlso))) {
      delegate.keyReleasedEvent();
    }

    textChangeListenerEnabled = true;
    return;
  }
  public List<String> filterItems(String searchText) {
    searchText = searchText.toLowerCase();
    List<String> result = new ArrayList<String>();

    for (int i = 0; i < this.items.size(); i++) {
      if (this.items.get(i).toLowerCase().equals(searchText)) {
        // full hit?
        result.clear();
        result.add(this.items.get(i));
        break;

      } else if (this.items.get(i).toLowerCase().contains(searchText)) {
        result.add(this.items.get(i));

      }
    }
    return result;
  }
  public boolean showCompletionAndBindIfPossible(boolean all, boolean focusChanged, String hint) {
    String text = this.getText().trim();
    List<String> results;

    if (text.trim().equals("")) {
      all = true;
    }

    if (all) {
      results = items;

    } else {
      results = filterItems(text);

    }

    if (hint != null && results.contains(hint)) {
      results = new ArrayList<String>();
      results.add(hint);
    }

    ll("showCompletionAndBindIfPossible", "results now " + results.size() + ", all " + all + ", focusChanged " + focusChanged);


    // okay, when loosing focus and the result is only one bind
    // jan 2021, removed && !all
    boolean itemFound = false;
    if (focusChanged && results.size() == 1) {
      itemFound = true;
      setItem(results.get(0));
      if (popup.isShowing()) {
        popup.hide();
      }

    } else if (!(focusChanged)) {
      populateMenu(results);

    }
    return itemFound;
  }

  public void issueBoundEvent() {
    issueBoundEvent = true;
  }
  public void setOptional(boolean opt) {
    optionalAlso = opt;
  }
  public void setIssueUpdate() {
    issueUpdateConclusion = true;
  }
  public boolean isIssueUpdate() {
    return issueUpdateConclusion;
  }
  public void setLastItemIssuedUpdate(String x) {
    lastItemIssuedUpdate = x;
  }
  public String getLastItemIssuedUpdate() {
    return lastItemIssuedUpdate;
  }
  public void setProvideHint() {
    provideHintEnabled = true;
  }
  public void ll(String m, String desc) {
  }
}
